/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.stats;

import hic.tools.utils.original.Chunk;
import hic.tools.utils.stats.ParallelStatisticsWorker;
import hic.tools.utils.stats.StatisticsContainer;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.reader.basics.ChromosomeHandler;

public class ParallelStatistics {
    private static final Object mergerLock = new Object();
    private final int numThreads;
    private final StatisticsContainer mergedContainer;
    private final AtomicInteger threadCounter = new AtomicInteger();
    private final List<Chunk> mndChunks;
    private final String siteFile;
    private final List<String> statsFiles;
    private final List<Integer> mapqThresholds;
    private final String ligationJunction;
    private final String inFile;
    private final ChromosomeHandler localHandler;

    public ParallelStatistics(int numThreads, StatisticsContainer mergedContainer, List<Chunk> mndChunks, String siteFile, List<String> statsFiles, List<Integer> mapqThresholds, String ligationJunction, String inFile, ChromosomeHandler localHandler) {
        this.numThreads = numThreads;
        this.mergedContainer = mergedContainer;
        this.mndChunks = mndChunks;
        this.siteFile = siteFile;
        this.statsFiles = statsFiles;
        this.mapqThresholds = mapqThresholds;
        this.ligationJunction = ligationJunction;
        this.inFile = inFile;
        this.localHandler = localHandler;
    }

    public void launchThreads() {
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        for (int l = 0; l < this.numThreads; ++l) {
            executor.execute(() -> this.runParallelizedStatistics(this.mergedContainer));
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runParallelizedStatistics(StatisticsContainer mergedContainer) {
        int currentCount = this.threadCounter.getAndIncrement();
        while (currentCount < this.mndChunks.size()) {
            Chunk chunk = this.mndChunks.get(currentCount);
            try {
                ParallelStatisticsWorker runner = new ParallelStatisticsWorker(this.siteFile, this.statsFiles, this.mapqThresholds, this.ligationJunction, this.inFile, this.localHandler);
                runner.infileStatistics(chunk);
                Object object = mergerLock;
                synchronized (object) {
                    mergedContainer.add(runner.getResultsContainer(), this.statsFiles.size());
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            currentCount = this.threadCounter.getAndIncrement();
        }
    }
}

