/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.other;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Pattern;
import javastraw.reader.type.HiCZoom;
import org.broad.igv.Globals;
import org.broad.igv.util.ParsingUtils;

public class HiCDBUtils {
    private static String DB_DRIVER;
    private static String DB_URL;
    private static String DB_USER;
    private static String DB_PASSWORD;

    public static void main(String[] args) throws IOException, SQLException {
        String cmd = args[0];
        if (HiCZoom.valueOfUnit(cmd) == HiCZoom.HiCUnit.FRAG) {
            String f = args[1];
            HiCDBUtils.insertFragments(f);
        } else if (cmd.equals("annot")) {
            String f = args[1];
            HiCDBUtils.insertAnnotationList(f);
            HiCDBUtils.updateFragmentAnnotations();
        } else if (cmd.equals("update")) {
            HiCDBUtils.updateFragmentAnnotations();
        } else {
            throw new IOException("Command not clear");
        }
    }

    private static void insertAnnotationList(String annotListFile) throws IOException, SQLException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(ParsingUtils.openInputStream(annotListFile)), 0x200000);){
            String nextLine;
            while ((nextLine = reader.readLine()) != null) {
                if (nextLine.startsWith("#")) continue;
                System.out.print("Processing " + nextLine);
                HiCDBUtils.insertAnnotations(nextLine);
                System.out.println("   DONE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertAnnotations(String line) throws IOException, SQLException {
        Connection dbConnection = null;
        String insertAnnotationSql = "INSERT INTO IGV.ANNOTATION (CHR, BEG, END, NAME, TYPE, SUBTYPE, CELL_TYPE, ALT_NAME, SCORE, ANTIBODY, SOURCE, REPLICATE, LINE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        Statement ps = null;
        String[] tk = Globals.whitespacePattern.split(line);
        String fragmentFile = tk[0];
        String celltype = tk[1];
        String altname = tk[2];
        String type = tk[3];
        String subtype = tk[4];
        String antibody = tk[5];
        String source = tk[6];
        String replicate = tk.length > 7 ? tk[7] : "";
        BufferedReader annotationReader = null;
        try {
            String nextLine;
            annotationReader = new BufferedReader(new InputStreamReader(ParsingUtils.openInputStream(fragmentFile)), 0x200000);
            dbConnection = HiCDBUtils.getDBConnection();
            ps = dbConnection.prepareStatement(insertAnnotationSql);
            dbConnection.setAutoCommit(false);
            int count = 0;
            while ((nextLine = annotationReader.readLine()) != null) {
                String[] tokens2 = Globals.whitespacePattern.split(nextLine);
                String chr = tokens2[0];
                int beg = Integer.parseInt(tokens2[1]);
                int end = Integer.parseInt(tokens2[2]);
                String name = tokens2[3];
                int score = Integer.parseInt(tokens2[4]);
                ps.setString(1, chr);
                ps.setInt(2, beg);
                ps.setInt(3, end);
                ps.setString(4, name);
                ps.setString(5, type);
                ps.setString(6, subtype);
                ps.setString(7, celltype);
                ps.setString(8, altname);
                ps.setInt(9, score);
                ps.setString(10, antibody);
                ps.setString(11, source);
                ps.setString(12, replicate);
                ps.setString(13, nextLine);
                ps.addBatch();
                if (++count % 1000 != 0) continue;
                ps.executeBatch();
                count = 0;
            }
            if (count > 0) {
                ps.executeBatch();
            }
            dbConnection.commit();
            annotationReader.close();
            annotationReader = null;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (dbConnection != null) {
                dbConnection.close();
            }
            if (annotationReader != null) {
                annotationReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertFragments(String fragmentFile) throws IOException, SQLException {
        Connection dbConnection = null;
        String insertTableSQL = "INSERT INTO IGV.FRAGMENT (TYPE, CHR, BEG, END, IDX) VALUES(?,?,?,?, ?)";
        PreparedStatement ps = null;
        BufferedReader fragmentReader = null;
        Pattern pattern = Pattern.compile("\\s");
        try {
            String nextLine;
            fragmentReader = new BufferedReader(new FileReader(fragmentFile), 0x200000);
            dbConnection = HiCDBUtils.getDBConnection();
            ps = dbConnection.prepareStatement(insertTableSQL);
            dbConnection.setAutoCommit(false);
            while ((nextLine = fragmentReader.readLine()) != null) {
                String[] tokens2 = pattern.split(nextLine);
                String chr = HiCDBUtils.getChrAlias(tokens2[0]);
                System.out.println("Processing " + chr);
                int beg = 0;
                int idx = 0;
                for (int i = 1; i < tokens2.length; ++i) {
                    int end = Integer.parseInt(tokens2[i]);
                    ps.setString(1, "MboI_5frag");
                    ps.setString(2, chr);
                    ps.setInt(3, beg);
                    ps.setInt(4, end);
                    ps.setInt(5, idx);
                    ps.addBatch();
                    beg = end;
                    ++idx;
                }
                ps.executeBatch();
            }
            dbConnection.commit();
        }
        finally {
            assert (dbConnection != null);
            dbConnection.close();
            assert (fragmentReader != null);
            fragmentReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateFragmentAnnotations() throws SQLException {
        String selectLastSQL = "SELECT MAX(ANNOTATION_ID) FROM FRAGMENT_ANNOTATION";
        String selectAnnotationSql = "SELECT ID, CHR, BEG, END FROM ANNOTATION WHERE ID > ? ORDER BY ID";
        String selectFragSql = "SELECT ID FROM FRAGMENT WHERE CHR = ? and BEG <= ? and END >= ?";
        String updateSQL = "INSERT INTO FRAGMENT_ANNOTATION (FRAGMENT_ID, ANNOTATION_ID) VALUES (?, ?)";
        Connection dbConnection = null;
        Statement lastIdPrepStat = null;
        PreparedStatement annotPrepStat = null;
        PreparedStatement fragPrepStat = null;
        Statement updatePrepStat = null;
        ResultSet lastIdRS = null;
        ResultSet annotRS = null;
        ResultSet fragRS = null;
        try {
            dbConnection = HiCDBUtils.getDBConnection();
            dbConnection.setAutoCommit(false);
            annotPrepStat = dbConnection.prepareStatement(selectAnnotationSql);
            fragPrepStat = dbConnection.prepareStatement(selectFragSql);
            updatePrepStat = dbConnection.prepareStatement(updateSQL);
            int updateCount = 0;
            lastIdPrepStat = dbConnection.prepareStatement(selectLastSQL);
            lastIdRS = lastIdPrepStat.executeQuery();
            int lastIDProcessed = 0;
            if (lastIdRS.next()) {
                lastIDProcessed = lastIdRS.getInt(1);
            }
            System.out.println("Last id processed = " + lastIDProcessed);
            annotPrepStat.setInt(1, lastIDProcessed);
            annotRS = annotPrepStat.executeQuery();
            while (annotRS.next()) {
                int annotID = annotRS.getInt(1);
                String chr = annotRS.getString(2);
                int beg = annotRS.getInt(3);
                int end = annotRS.getInt(4);
                fragPrepStat.setString(1, chr);
                fragPrepStat.setInt(2, end);
                fragPrepStat.setInt(3, beg);
                fragRS = fragPrepStat.executeQuery();
                while (fragRS.next()) {
                    int fragID = fragRS.getInt(1);
                    updatePrepStat.setInt(1, fragID);
                    updatePrepStat.setInt(2, annotID);
                    updatePrepStat.addBatch();
                    if (++updateCount % 100 != 0) continue;
                    updatePrepStat.executeBatch();
                    updateCount = 0;
                    dbConnection.commit();
                }
                fragRS.close();
                fragRS = null;
            }
            if (updateCount > 0) {
                updatePrepStat.executeBatch();
            }
            dbConnection.commit();
        }
        finally {
            if (annotRS != null) {
                annotRS.close();
            }
            if (lastIdRS != null) {
                lastIdRS.close();
            }
            if (fragRS != null) {
                fragRS.close();
            }
            if (lastIdPrepStat != null) {
                lastIdPrepStat.close();
            }
            if (annotPrepStat != null) {
                annotPrepStat.close();
            }
            if (updatePrepStat != null) {
                updatePrepStat.close();
            }
            if (fragPrepStat != null) {
                fragPrepStat.close();
            }
            if (dbConnection != null) {
                dbConnection.close();
            }
        }
    }

    private static Connection getDBConnection() {
        if (DB_DRIVER == null) {
            DB_DRIVER = System.getProperty("DB_DRIVER");
            DB_URL = System.getProperty("DB_URL");
            DB_USER = System.getProperty("DB_USER");
            DB_PASSWORD = System.getProperty("DB_PASSWORD");
        }
        Connection dbConnection = null;
        try {
            Class.forName(DB_DRIVER);
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
        }
        try {
            dbConnection = DriverManager.getConnection(DB_URL, DB_USER, DB_PASSWORD);
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        return dbConnection;
    }

    private static String getChrAlias(String token) {
        if (token.equals("MT")) {
            return "chrM";
        }
        if (!token.startsWith("chr")) {
            return "chr" + token;
        }
        return token;
    }
}

