/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.other;

import java.io.IOException;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BigWigIterator;
import org.broad.igv.bbfile.WigItem;

public class BigWigUtils {
    public static void computeBins(String path, int windowSize) throws IOException {
        BBFileReader reader = new BBFileReader(path);
        for (String chr : reader.getChromosomeNames()) {
            BigWigUtils.computeBins(reader, chr, 0, Integer.MAX_VALUE, windowSize);
        }
    }

    public static void computeBins(String path, String chr, int start, int end, int windowSize) throws IOException {
        BBFileReader reader = new BBFileReader(path);
        boolean found = false;
        StringBuilder errString = new StringBuilder();
        for (String chr1 : reader.getChromosomeNames()) {
            if (chr.equals(chr1)) {
                found = true;
            }
            errString.append("\"").append(chr1).append("\" ");
        }
        if (!found) {
            System.err.println("Chromosome \"" + chr + "\" not found in " + path);
            System.err.println("The chromosomes in " + path + " are " + errString);
            return;
        }
        BigWigUtils.computeBins(reader, chr, start, end, windowSize);
    }

    private static void computeBins(BBFileReader reader, String chr, int start, int end, int windowSize) {
        BigWigIterator iter = reader.getBigWigIterator(chr, start, chr, end, false);
        double sum = 0.0;
        int nPts = 0;
        double max = 0.0;
        int currentBin = 0;
        while (iter.hasNext()) {
            WigItem datum = iter.next();
            int dPosition = (datum.getStartBase() + datum.getEndBase()) / 2;
            if (dPosition > (currentBin + 1) * windowSize) {
                double mean = sum / (double)nPts;
                int wStart = windowSize * currentBin;
                int wEnd = wStart + windowSize;
                System.out.println(chr + "\t" + wStart + "\t" + wEnd + "\t" + mean + "\t" + max);
                ++currentBin;
                while (currentBin < dPosition / windowSize) {
                    wStart = windowSize * currentBin;
                    wEnd = wStart + windowSize;
                    mean = 0.0;
                    max = 0.0;
                    System.out.println(chr + "\t" + wStart + "\t" + wEnd + "\t" + mean + "\t" + max);
                    ++currentBin;
                }
                currentBin = dPosition / windowSize;
                sum = 0.0;
                nPts = 0;
                max = 0.0;
            }
            sum += (double)datum.getWigValue();
            max = Math.max(max, (double)datum.getWigValue());
            ++nPts;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Chromosome and window size are required");
            System.exit(5);
        }
        String path = args[0];
        int windowSize = Integer.parseInt(args[1]);
        if (args.length == 2) {
            BigWigUtils.computeBins(path, windowSize);
        } else {
            String chr = args[2];
            if (args.length == 3) {
                BigWigUtils.computeBins(path, chr, 0, Integer.MAX_VALUE, windowSize);
            } else {
                int start = Integer.parseInt(args[3]) - 1;
                int end = Integer.parseInt(args[4]);
                BigWigUtils.computeBins(path, chr, start, end, windowSize);
            }
        }
    }
}

