/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.original;

import hic.tools.utils.original.BlockPP;
import htsjdk.tribble.util.LittleEndianInputStream;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;

public class RecordBlockUtils {
    public static int getNumberOfRecords(Map<Point, Float> records, int countThreshold) {
        if (countThreshold > 0) {
            int nRecords = 0;
            for (Float value : records.values()) {
                if (!(value.floatValue() >= (float)countThreshold)) continue;
                ++nRecords;
            }
            return nRecords;
        }
        return records.size();
    }

    public static byte[] compress(byte[] data, Deflater compressor) {
        compressor.reset();
        compressor.setInput(data);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            System.err.println("Error closing ByteArrayOutputStream");
            e.printStackTrace();
        }
        return bos.toByteArray();
    }

    public static void readAndMerge(BlockPP currentBlock, Map.Entry<File, Long> entry) throws IOException {
        BlockPP tmpBlock = RecordBlockUtils.readTmpBlock(entry.getKey(), entry.getValue());
        if (tmpBlock != null) {
            currentBlock.merge(tmpBlock);
        }
    }

    public static BlockPP readTmpBlock(File file, long filePosition) throws IOException {
        if (filePosition >= file.length()) {
            return null;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            int count;
            fis.getChannel().position(filePosition);
            LittleEndianInputStream lis = new LittleEndianInputStream(fis);
            int blockNumber = lis.readInt();
            int nRecords = lis.readInt();
            byte[] bytes2 = new byte[nRecords * 12];
            int len = bytes2.length;
            for (int n = 0; n < len; n += count) {
                count = fis.read(bytes2, n, len - n);
                if (count >= 0) continue;
                throw new EOFException();
            }
            BlockPP blockPP = new BlockPP(blockNumber, RecordBlockUtils.readContactRecordsToMap(nRecords, bytes2));
            return blockPP;
        }
    }

    public static Map<Point, Float> readContactRecordsToMap(int nRecords, byte[] bytes2) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes2);
        LittleEndianInputStream lis = new LittleEndianInputStream(bis);
        HashMap<Point, Float> contactRecordMap = new HashMap<Point, Float>(nRecords);
        for (int i = 0; i < nRecords; ++i) {
            int x = lis.readInt();
            int y = lis.readInt();
            float v = lis.readFloat();
            contactRecordMap.put(new Point(x, y), Float.valueOf(v));
        }
        try {
            lis.close();
            bis.close();
        }
        catch (Exception e) {
            System.err.println("Error cleanup contact record to map = " + e.getLocalizedMessage());
        }
        return contactRecordMap;
    }
}

