/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.original;

import hic.tools.utils.iterators.contacts.AllByAllContactsIterator;
import hic.tools.utils.iterators.contacts.ChromosomeContactsIterator;
import hic.tools.utils.iterators.contacts.Contact;
import hic.tools.utils.merge.HiCMergeTools;
import hic.tools.utils.original.DataReadingWorker;
import hic.tools.utils.original.HiCFileBuilder;
import hic.tools.utils.original.IndexEntry;
import hic.tools.utils.original.MatrixPP;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Deflater;
import javastraw.reader.Dataset;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.mzd.Matrix;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.HiCZoom;

public class PreprocessorFromDatasets
extends HiCFileBuilder {
    public static final Object key = new Object();
    private final Dataset[] datasets;
    private int highestResolution;

    public PreprocessorFromDatasets(File outputFile, Dataset[] datasets, double hicFileScalingFactor, String tmpDir) {
        super(outputFile, datasets[0].getGenomeId(), hicFileScalingFactor, tmpDir);
        this.datasets = datasets;
        this.updateResolutionsToBuild(datasets[0].getAllPossibleResolutions(), 0);
        this.highestResolution = this.getMin(this.bpBinSizes);
    }

    private void updateResolutionsToBuild(List<HiCZoom> zooms, int minCutoff) {
        ArrayList<Integer> resolutions = new ArrayList<Integer>();
        for (HiCZoom zoom : zooms) {
            if (zoom.getBinSize() < minCutoff) continue;
            resolutions.add(zoom.getBinSize());
        }
        this.setResolutionsWithInts(resolutions);
    }

    private int getMin(int[] zooms) {
        int minValue = zooms[0];
        for (int zoom : zooms) {
            if (zoom >= minValue) continue;
            minValue = zoom;
        }
        return minValue;
    }

    public void preprocess() throws IOException {
        HiCMergeTools.mergeStatsAndGraphs(this.datasets, this.tmpDir, this);
        try {
            LittleEndianOutputStream[] losFooter = this.initializeLosArrays(this.outputFile.getAbsolutePath(), this.outputFile.getAbsolutePath());
            this.writeHeader();
            this.writeBody();
            this.writeFooter(losFooter);
            PreprocessorFromDatasets.closeLosArray(losFooter);
        }
        finally {
            PreprocessorFromDatasets.closeLosArray(this.losArray);
        }
        this.updateMasterIndex(this.outputFile.getAbsolutePath());
        System.out.println("\nFinished preprocess");
    }

    private MatrixPP computeWholeGenomeMatrix(Dataset[] datasets) {
        MatrixPP matrix = this.getInitialGenomeWideMatrixPP(this.chromosomeHandler);
        try {
            AllByAllContactsIterator iter = new AllByAllContactsIterator(datasets);
            while (iter.hasNext()) {
                matrix.incrementCount(iter.next(), this.expectedValueCalculations, this.tmpDir);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(98);
        }
        matrix.parsingComplete();
        return matrix;
    }

    private static void writeMatrixToFile(MatrixPP mergedMatrix, LittleEndianOutputStream[] losArray, Deflater compressor, Map<String, IndexEntry> matrixPositions, File outputFile) {
        try {
            PreprocessorFromDatasets.writeMatrix(mergedMatrix, losArray, compressor, matrixPositions, -1, false, outputFile);
        }
        catch (IOException e) {
            System.err.println("Unable to write matrix data to hic file");
            e.printStackTrace();
            System.exit(89);
        }
    }

    private void writeBody() throws IOException {
        System.out.println("Writing body");
        this.writeWholeGenomeMatrix(this.datasets, this.losArray, this.compressor, this.matrixPositions);
        Chromosome[] chromosomes = this.chromosomeHandler.getChromosomeArrayWithoutAllByAll();
        for (int i = 0; i < chromosomes.length; ++i) {
            for (int j = i; j < chromosomes.length; ++j) {
                if (this.intraChromosomalOnly && i != j) continue;
                this.readInChromosomeRegionMatrixST(chromosomes[i], chromosomes[j], this.datasets, this.losArray, this.compressor, this.matrixPositions);
                System.out.println("*");
            }
            System.out.println("*");
        }
        this.masterIndexPosition = this.losArray[0].getWrittenCount();
    }

    private void readInChromosomeRegionMatrixST(Chromosome chromosome1, Chromosome chromosome2, Dataset[] datasets, LittleEndianOutputStream[] losArray, Deflater compressor, Map<String, IndexEntry> matrixPositions) {
        MatrixPP mergedMatrix = new MatrixPP(chromosome1.getIndex(), chromosome2.getIndex(), this.chromosomeHandler, this.bpBinSizes, this.countThreshold, this.v9DepthBase, BLOCK_CAPACITY);
        for (Dataset dataset : datasets) {
            Matrix matrix = dataset.getMatrix(chromosome1, chromosome2, this.highestResolution);
            if (matrix == null) {
                System.err.println("Skipping null matrix " + chromosome1.getName() + " " + chromosome2.getName());
                return;
            }
            HiCZoom hZoom = new HiCZoom(this.highestResolution);
            MatrixZoomData zd = matrix.getZoomData(hZoom);
            if (zd == null) {
                System.err.println("Skipping null zd (res=" + this.highestResolution + ") " + chromosome1.getName() + " " + chromosome2.getName());
                return;
            }
            try {
                ChromosomeContactsIterator iter = new ChromosomeContactsIterator(zd, chromosome1, chromosome2, this.highestResolution);
                if (!iter.hasNext()) {
                    System.err.println("No data in dataset for region: " + zd.getKey());
                }
                while (iter.hasNext()) {
                    Contact contact = iter.next();
                    if (this.onlyNearDiagonalContacts && DataReadingWorker.tooFarFromDiagonal(contact)) continue;
                    mergedMatrix.incrementCount(contact, this.expectedValueCalculations, this.tmpDir);
                }
            }
            catch (Exception e) {
                System.err.println("ERROR " + e.getLocalizedMessage());
                System.err.println("Skipping dataset for region: " + chromosome1.getName() + "_" + chromosome2.getName());
                e.printStackTrace();
                System.exit(90);
            }
            matrix.clearCacheForZoom(hZoom);
        }
        mergedMatrix.parsingComplete();
        PreprocessorFromDatasets.writeMatrixToFile(mergedMatrix, losArray, compressor, matrixPositions, this.outputFile);
        mergedMatrix = null;
    }

    private void readInChromosomeRegionMatrixMT(Chromosome chromosome1, Chromosome chromosome2, Dataset[] datasets, LittleEndianOutputStream[] losArray, Deflater compressor, Map<String, IndexEntry> matrixPositions) {
        MatrixPP mergedMatrix = new MatrixPP(chromosome1.getIndex(), chromosome2.getIndex(), this.chromosomeHandler, this.bpBinSizes, this.countThreshold, this.v9DepthBase, BLOCK_CAPACITY);
        AtomicInteger index = new AtomicInteger();
        int numCPUThreads = 3;
        ExecutorService executor = Executors.newFixedThreadPool(numCPUThreads);
        for (int l = 0; l < numCPUThreads; ++l) {
            executor.execute(new DataReadingWorker(index, chromosome1, chromosome2, this.chromosomeHandler, this.bpBinSizes, this.countThreshold, this.v9DepthBase, BLOCK_CAPACITY, datasets, this.highestResolution, this.expectedValueCalculations, this.tmpDir, mergedMatrix, this.onlyNearDiagonalContacts));
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        mergedMatrix.parsingComplete();
        PreprocessorFromDatasets.writeMatrixToFile(mergedMatrix, losArray, compressor, matrixPositions, this.outputFile);
        mergedMatrix = null;
    }

    private void writeWholeGenomeMatrix(Dataset[] datasets, LittleEndianOutputStream[] losArray, Deflater compressor, Map<String, IndexEntry> matrixPositions) throws IOException {
        MatrixPP wholeGenomeMatrix = this.computeWholeGenomeMatrix(datasets);
        PreprocessorFromDatasets.writeMatrix(wholeGenomeMatrix, losArray, compressor, matrixPositions, -1, false, this.outputFile);
        wholeGenomeMatrix = null;
    }

    public void setHighestResolution(List<String> resolutions) {
        if (resolutions != null && resolutions.size() > 0) {
            try {
                this.highestResolution = Integer.parseInt(resolutions.get(0));
            }
            catch (Exception e) {
                System.err.println("Unable to parse resolution " + resolutions.get(0));
            }
        }
        this.updateResolutionsToBuild(this.datasets[0].getAllPossibleResolutions(), this.highestResolution);
    }
}

