/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.original;

import hic.tools.utils.cleaner.ContactCleaner;
import hic.tools.utils.iterators.mnd.AlignmentPair;
import hic.tools.utils.iterators.mnd.PairIterator;
import hic.tools.utils.original.Chunk;
import hic.tools.utils.original.HiCFileBuilder;
import hic.tools.utils.original.MatrixPP;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Preprocessor
extends HiCFileBuilder {
    public Preprocessor(File outputFile, String genomeId, double hicFileScalingFactor, String tmp) {
        super(outputFile, genomeId, hicFileScalingFactor, tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preprocess(String inputFile, String headerFile, String footerFile, Map<Integer, List<Chunk>> mndIndex) throws IOException {
        File file = new File(inputFile);
        if (!file.exists() || file.length() == 0L) {
            System.err.println(inputFile + " does not exist or does not contain any reads.");
            System.exit(57);
        }
        try {
            LittleEndianOutputStream[] losFooter = this.initializeLosArrays(headerFile, footerFile);
            this.writeHeader();
            this.writeBody(inputFile, mndIndex);
            this.writeFooter(losFooter);
            Preprocessor.closeLosArray(losFooter);
        }
        finally {
            Preprocessor.closeLosArray(this.losArray);
        }
        this.updateMasterIndex(headerFile);
        System.out.println("\nFinished preprocess");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MatrixPP computeWholeGenomeMatrix(String file) throws IOException {
        MatrixPP matrix = this.getInitialGenomeWideMatrixPP(this.chromosomeHandler);
        try (PairIterator iter = null;){
            iter = PairIterator.getIterator(file, this.chromosomeIndexes, this.chromosomeHandler);
            while (iter.hasNext()) {
                AlignmentPair pair = iter.next();
                if (!pair.isNotContigPair()) continue;
                int bp1 = pair.getPos1();
                int bp2 = pair.getPos2();
                int chr1 = pair.getChr1();
                int chr2 = pair.getChr2();
                if (this.shouldSkipContact(pair)) continue;
                int pos1 = ContactCleaner.getWholeGenomePosition(chr1, bp1, this.chromosomeHandler);
                int pos2 = ContactCleaner.getWholeGenomePosition(chr2, bp2, this.chromosomeHandler);
                matrix.incrementCount(pos1, pos2, pair.getScore(), this.expectedValueCalculations, this.tmpDir);
            }
        }
        matrix.parsingComplete();
        return matrix;
    }

    protected void writeBody(String inputFile, Map<Integer, List<Chunk>> mndIndex) throws IOException {
        System.out.println("Writing body");
        MatrixPP wholeGenomeMatrix = this.computeWholeGenomeMatrix(inputFile);
        Preprocessor.writeMatrix(wholeGenomeMatrix, this.losArray, this.compressor, this.matrixPositions, -1, false, this.outputFile);
        PairIterator iter = PairIterator.getIterator(inputFile, this.chromosomeIndexes, this.chromosomeHandler);
        Set<String> writtenMatrices = Collections.synchronizedSet(new HashSet());
        int currentChr1 = -1;
        int currentChr2 = -1;
        MatrixPP currentMatrix = null;
        String currentMatrixKey = null;
        ContactCleaner cleaner = new ContactCleaner(this.chromosomeHandler);
        while (iter.hasNext()) {
            AlignmentPair pair = iter.next();
            if (!pair.isNotContigPair() || this.shouldSkipContact(pair)) continue;
            cleaner.updateLatestContact(pair);
            if (cleaner.doesntMatchCurrentBlock(currentChr1, currentChr2)) {
                if (currentMatrix != null) {
                    currentMatrix.parsingComplete();
                    Preprocessor.writeMatrix(currentMatrix, this.losArray, this.compressor, this.matrixPositions, -1, false, this.outputFile);
                    writtenMatrices.add(currentMatrixKey);
                    currentMatrix = null;
                    System.gc();
                }
                currentChr1 = cleaner.getChr1();
                currentChr2 = cleaner.getChr2();
                currentMatrixKey = currentChr1 + "_" + currentChr2;
                if (writtenMatrices.contains(currentMatrixKey)) {
                    System.err.println("Error: the chromosome combination " + currentMatrixKey + " appears in multiple blocks");
                    if (this.outputFile != null) {
                        this.outputFile.deleteOnExit();
                    }
                    System.exit(58);
                }
                currentMatrix = new MatrixPP(currentChr1, currentChr2, this.chromosomeHandler, this.bpBinSizes, this.countThreshold, this.v9DepthBase, BLOCK_CAPACITY);
            }
            cleaner.incrementCount(currentMatrix, this.expectedValueCalculations, this.tmpDir);
        }
        if (currentMatrix != null) {
            currentMatrix.parsingComplete();
            Preprocessor.writeMatrix(currentMatrix, this.losArray, this.compressor, this.matrixPositions, -1, false, this.outputFile);
        }
        iter.close();
        this.masterIndexPosition = this.losArray[0].getWrittenCount();
    }

    protected boolean shouldSkipContact(AlignmentPair pair) {
        int chr1 = pair.getChr1();
        int chr2 = pair.getChr2();
        if (this.intraChromosomalOnly && chr1 != chr2) {
            return true;
        }
        if (this.onlyNearDiagonalContacts && Preprocessor.tooFarFromDiagonal(pair.getPos1(), pair.getPos2())) {
            return true;
        }
        if (this.includedChromosomes != null && chr1 != 0) {
            String c1Name = this.chromosomeHandler.getChromosomeFromIndex(chr1).getName();
            String c2Name = this.chromosomeHandler.getChromosomeFromIndex(chr2).getName();
            if (!this.includedChromosomes.contains(c1Name) || !this.includedChromosomes.contains(c2Name)) {
                return true;
            }
        }
        if (this.filter != null && !this.filter.pairTypesAreEqual(pair)) {
            return true;
        }
        int mapq = Math.min(pair.getMapq1(), pair.getMapq2());
        return mapq < this.mapqThreshold;
    }
}

