/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.original;

import hic.tools.utils.cleaner.ContactCleaner;
import hic.tools.utils.iterators.mnd.AlignmentPair;
import hic.tools.utils.iterators.mnd.AsciiPairIterator;
import hic.tools.utils.original.Chunk;
import hic.tools.utils.original.ExpectedValueCalculation;
import hic.tools.utils.original.IndexEntry;
import hic.tools.utils.original.MTIndexHandler;
import hic.tools.utils.original.MatrixPP;
import hic.tools.utils.original.Preprocessor;
import hic.tools.utils.original.WriterUtils;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Deflater;
import javastraw.reader.type.NormalizationHandler;
import javastraw.tools.ParallelizationTools;
import org.broad.igv.util.Pair;

public class MultithreadedPreprocessor
extends Preprocessor {
    public static final String CAT_SCRIPT = "_cat_outputs.sh";
    private final Map<Integer, String> chromosomePairIndexes = new ConcurrentHashMap<Integer, String>();
    private final Map<String, Integer> chromosomePairIndexesReverse = new ConcurrentHashMap<String, Integer>();
    private final Map<Integer, Integer> chromosomePairIndex1 = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, Integer> chromosomePairIndex2 = new ConcurrentHashMap<Integer, Integer>();
    private final int chromosomePairCounter;
    private final Map<Integer, Integer> nonemptyChromosomePairs = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, Map<Integer, MatrixPP>> wholeGenomeMatrixParts = new ConcurrentHashMap<Integer, Map<Integer, MatrixPP>>();
    private final Map<String, IndexEntry> localMatrixPositions = new ConcurrentHashMap<String, IndexEntry>();
    private final Map<Integer, Long> matrixSizes = new ConcurrentHashMap<Integer, Long>();
    private final Map<Integer, Map<Long, List<IndexEntry>>> chromosomePairBlockIndexes;
    protected static int numCPUThreads = 1;
    private final Map<Integer, Map<String, ExpectedValueCalculation>> allLocalExpectedValueCalculations;
    protected static Map<Integer, List<Chunk>> mndIndex = null;
    private final AtomicInteger chunkCounter = new AtomicInteger(0);
    private int totalChunks = 0;
    private final ConcurrentHashMap<Integer, AtomicInteger> completedChunksPerChrPair = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Integer> numChunksPerChrPair = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, AtomicInteger> chrPairCompleted = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, AtomicInteger> chrPairAvailableThreads = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Integer> chrPairBlockCapacities = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Integer> chunkCounterToChrPairMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Integer> chunkCounterToChrChunkMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Map<Integer, Pair<Pair<Integer, Integer>, MatrixPP>>> threadSpecificChrPairMatrices = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, MatrixPP> finalChrMatrices = new ConcurrentHashMap();

    public MultithreadedPreprocessor(File outputFile, String genomeId, double hicFileScalingFactor, int numCPUThreads, String mndIndexFile, String tmpDir) throws IOException {
        super(outputFile, genomeId, hicFileScalingFactor, tmpDir);
        MultithreadedPreprocessor.numCPUThreads = numCPUThreads;
        this.chromosomeIndexes = MTIndexHandler.populateChromosomeIndexes(this.chromosomeHandler, numCPUThreads);
        this.chromosomePairCounter = MTIndexHandler.populateChromosomePairIndexes(this.chromosomeHandler, this.chromosomePairIndexes, this.chromosomePairIndexesReverse, this.chromosomePairIndex1, this.chromosomePairIndex2);
        this.setMndIndex(mndIndexFile, this.chromosomePairIndexes);
        this.chromosomePairBlockIndexes = new ConcurrentHashMap<Integer, Map<Long, List<IndexEntry>>>(this.chromosomePairCounter, 0.75f, numCPUThreads);
        this.allLocalExpectedValueCalculations = new ConcurrentHashMap<Integer, Map<String, ExpectedValueCalculation>>(numCPUThreads, 0.75f, numCPUThreads);
    }

    public void setMndIndex(String mndIndexFile, Map<Integer, String> chromosomePairIndexes) throws IOException {
        if (mndIndexFile == null || mndIndexFile.length() <= 1) {
            throw new IOException("No mndIndex provided");
        }
        mndIndex = MTIndexHandler.readMndIndex(mndIndexFile, chromosomePairIndexes);
    }

    @Override
    public void preprocess(String inputFile, String ignore1, String ignore2, Map<Integer, List<Chunk>> ignore3) throws IOException {
        super.preprocess(inputFile, this.outputFile + "_header", this.outputFile + "_footer", mndIndex);
        try {
            PrintWriter finalOutput = new PrintWriter(this.outputFile + CAT_SCRIPT);
            StringBuilder catOutputLine = new StringBuilder();
            StringBuilder removeLine = new StringBuilder();
            catOutputLine.append("cat ").append(this.outputFile).append("_header");
            removeLine.append("rm ").append(this.outputFile).append("_header");
            for (int i = 0; i < this.chromosomePairCounter; ++i) {
                int numOfNeededThreads;
                if ((!this.nonemptyChromosomePairs.containsKey(i) || !this.chromosomePairBlockIndexes.containsKey(i) || !mndIndex.containsKey(i)) && i != 0) continue;
                catOutputLine.append(" ").append(this.outputFile).append("_").append(this.chromosomePairIndexes.get(i));
                removeLine.append(" ").append(this.outputFile).append("_").append(this.chromosomePairIndexes.get(i));
                if (i <= 0 || (numOfNeededThreads = this.chrPairAvailableThreads.get(i).get()) <= 1) continue;
                for (int j = 1; j <= numOfNeededThreads * this.numResolutions; ++j) {
                    catOutputLine.append(" ").append(this.outputFile).append("_").append(this.chromosomePairIndexes.get(i)).append("_").append(j);
                    removeLine.append(" ").append(this.outputFile).append("_").append(this.chromosomePairIndexes.get(i)).append("_").append(j);
                }
            }
            catOutputLine.append(" ").append(this.outputFile).append("_footer").append(" > ").append(this.outputFile).append("\n");
            removeLine.append(" ").append(this.outputFile).append("_footer\n");
            finalOutput.println(catOutputLine);
            finalOutput.println(removeLine);
            finalOutput.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Unable to write to catOutputs.sh");
            System.exit(70);
        }
    }

    private Pair<Pair<Integer, Integer>, MatrixPP> processIndividualMatrixChunk(String inputFile, int chunkNumber, int currentChrPair, Set<String> syncWrittenMatrices, Map<String, ExpectedValueCalculation> localExpectedValueCalculations, int threadNum) throws IOException {
        int chrPair;
        MatrixPP wholeGenomeMatrix = this.getInitialGenomeWideMatrixPP(this.chromosomeHandler);
        int i = chunkNumber;
        int chunksProcessed = 0;
        int currentChr1 = -1;
        int currentChr2 = -1;
        MatrixPP currentMatrix = null;
        while (i < this.totalChunks && (chrPair = this.chunkCounterToChrPairMap.get(i).intValue()) == currentChrPair) {
            int chrChunk = this.chunkCounterToChrChunkMap.get(i);
            List<Chunk> chunkPositions = mndIndex.get(chrPair);
            AsciiPairIterator iter = null;
            if (mndIndex == null) {
                System.err.println("No index for merged nodups file.");
                System.exit(67);
            } else {
                iter = new AsciiPairIterator(inputFile, (Map<String, Integer>)this.chromosomeIndexes, chunkPositions.get(chrChunk), this.chromosomeHandler);
            }
            ContactCleaner cleaner = new ContactCleaner(this.chromosomeHandler);
            while (iter.hasNext()) {
                AlignmentPair pair = iter.next();
                if (!pair.isNotContigPair() || this.shouldSkipContact(pair)) continue;
                cleaner.updateLatestContact(pair);
                if (cleaner.doesntMatchCurrentBlock(currentChr1, currentChr2)) {
                    currentChr1 = cleaner.getChr1();
                    currentChr2 = cleaner.getChr2();
                    String currentMatrixKey = currentChr1 + "_" + currentChr2;
                    String currentMatrixName = cleaner.getCurrentMatrixName();
                    int currentPairIndex = this.chromosomePairIndexesReverse.get(currentMatrixName);
                    if (currentPairIndex != currentChrPair) break;
                    if (syncWrittenMatrices.contains(currentMatrixKey)) {
                        System.err.println("Error: the chromosome combination " + currentMatrixKey + " appears in multiple blocks");
                        if (this.outputFile != null) {
                            this.outputFile.deleteOnExit();
                        }
                        System.exit(58);
                    }
                    currentMatrix = new MatrixPP(currentChr1, currentChr2, this.chromosomeHandler, this.bpBinSizes, this.countThreshold, this.v9DepthBase, (int)this.chrPairBlockCapacities.get(currentChrPair));
                }
                cleaner.incrementCount(currentMatrix, localExpectedValueCalculations, this.tmpDir);
                cleaner.incrementGWCount(wholeGenomeMatrix, localExpectedValueCalculations, this.tmpDir);
            }
            iter.close();
            ++chunksProcessed;
            i = this.chunkCounter.getAndIncrement();
        }
        if (currentMatrix != null) {
            currentMatrix.parsingComplete();
        }
        this.wholeGenomeMatrixParts.get(currentChrPair).put(threadNum, wholeGenomeMatrix);
        return new Pair<Pair<Integer, Integer>, MatrixPP>(new Pair<Integer, Integer>(i, chunksProcessed), currentMatrix);
    }

    @Override
    protected void writeBody(String inputFile, Map<Integer, List<Chunk>> mndIndex) throws IOException {
        Set syncWrittenMatrices = Collections.synchronizedSet(new HashSet());
        for (int chrPair = 1; chrPair < this.chromosomePairCounter; ++chrPair) {
            if (!mndIndex.containsKey(chrPair)) continue;
            int numOfChunks = mndIndex.get(chrPair).size();
            this.completedChunksPerChrPair.put(chrPair, new AtomicInteger(0));
            this.numChunksPerChrPair.put(chrPair, numOfChunks);
            this.chrPairCompleted.put(chrPair, new AtomicInteger(0));
            this.chrPairAvailableThreads.put(chrPair, new AtomicInteger(0));
            this.chrPairBlockCapacities.put(chrPair, BLOCK_CAPACITY / Math.min(numCPUThreads, numOfChunks));
            this.threadSpecificChrPairMatrices.put(chrPair, new ConcurrentHashMap());
            this.wholeGenomeMatrixParts.put(chrPair, new ConcurrentHashMap());
            for (int i = 0; i < numOfChunks; ++i) {
                int currentChunk = this.totalChunks++;
                this.chunkCounterToChrPairMap.put(currentChunk, chrPair);
                this.chunkCounterToChrChunkMap.put(currentChunk, i);
            }
        }
        ExecutorService executor = Executors.newFixedThreadPool(numCPUThreads);
        int i = 1;
        while (i < numCPUThreads) {
            int threadNum = i++;
            Runnable worker = () -> {
                try {
                    int currentChunk = this.chunkCounter.getAndIncrement();
                    LinkedHashMap<String, ExpectedValueCalculation> localExpectedValueCalculations = new LinkedHashMap<String, ExpectedValueCalculation>();
                    for (int bBinSize : this.bpBinSizes) {
                        ExpectedValueCalculation calc = new ExpectedValueCalculation(this.chromosomeHandler, bBinSize, NormalizationHandler.NONE);
                        String key = "BP_" + bBinSize;
                        localExpectedValueCalculations.put(key, calc);
                    }
                    while (currentChunk < this.totalChunks) {
                        int currentChrPair = this.chunkCounterToChrPairMap.get(currentChunk);
                        this.threadSpecificChrPairMatrices.get(currentChrPair).put(threadNum, this.processIndividualMatrixChunk(inputFile, currentChunk, currentChrPair, syncWrittenMatrices, localExpectedValueCalculations, threadNum));
                        ConcurrentHashMap<Integer, MatrixPP> concurrentHashMap = this.finalChrMatrices;
                        synchronized (concurrentHashMap) {
                            if (!this.finalChrMatrices.containsKey(currentChrPair)) {
                                int currentChr1 = this.chromosomePairIndex1.get(currentChrPair);
                                int currentChr2 = this.chromosomePairIndex2.get(currentChrPair);
                                this.finalChrMatrices.put(currentChrPair, new MatrixPP(currentChr1, currentChr2, this.chromosomeHandler, this.bpBinSizes, this.countThreshold, this.v9DepthBase, (int)this.chrPairBlockCapacities.get(currentChrPair)));
                            }
                            MatrixPP currentChr1 = this.finalChrMatrices.get(currentChrPair);
                            synchronized (currentChr1) {
                                this.finalChrMatrices.get(currentChrPair).mergeMatrices(this.threadSpecificChrPairMatrices.get(currentChrPair).get(threadNum).getSecond());
                            }
                        }
                        for (int completedChunks = 0; completedChunks < this.threadSpecificChrPairMatrices.get(currentChrPair).get(threadNum).getFirst().getSecond(); ++completedChunks) {
                            this.completedChunksPerChrPair.get(currentChrPair).getAndIncrement();
                        }
                        currentChunk = this.threadSpecificChrPairMatrices.get(currentChrPair).get(threadNum).getFirst().getFirst();
                        int currentAvailableThreads = this.chrPairAvailableThreads.get(currentChrPair).incrementAndGet();
                        if (this.completedChunksPerChrPair.get(currentChrPair).get() == this.numChunksPerChrPair.get(currentChrPair).intValue()) {
                            this.writeIndividualMatrix(currentChrPair, currentAvailableThreads);
                            this.finalChrMatrices.remove(currentChrPair);
                            this.threadSpecificChrPairMatrices.remove(currentChrPair);
                            this.chrPairCompleted.get(currentChrPair).getAndIncrement();
                        }
                        while (this.chrPairCompleted.get(currentChrPair).get() == 0) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                System.err.println(e.getLocalizedMessage());
                            }
                        }
                    }
                    this.allLocalExpectedValueCalculations.put(threadNum, localExpectedValueCalculations);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            };
            executor.execute(worker);
        }
        ParallelizationTools.shutDownAndWaitUntilDone(executor, 1000);
        for (i = 0; i < numCPUThreads; ++i) {
            if (this.allLocalExpectedValueCalculations.get(i) == null) continue;
            for (Map.Entry<String, ExpectedValueCalculation> entry : this.allLocalExpectedValueCalculations.get(i).entrySet()) {
                ((ExpectedValueCalculation)this.expectedValueCalculations.get(entry.getKey())).merge(entry.getValue());
            }
        }
        MatrixPP wholeGenomeMatrix = this.getInitialGenomeWideMatrixPP(this.chromosomeHandler);
        for (int i2 = 1; i2 < this.chromosomePairCounter; ++i2) {
            if (!this.nonemptyChromosomePairs.containsKey(i2) || !this.wholeGenomeMatrixParts.containsKey(i2)) continue;
            for (Map.Entry<Integer, MatrixPP> entry : this.wholeGenomeMatrixParts.get(i2).entrySet()) {
                wholeGenomeMatrix.mergeMatrices(entry.getValue());
            }
        }
        FileOutputStream tempFOS = new FileOutputStream(this.outputFile + "_" + this.chromosomePairIndexes.get(0));
        LittleEndianOutputStream tempLOS = new LittleEndianOutputStream(new BufferedOutputStream(tempFOS, 0x200000));
        LittleEndianOutputStream[] localLos = new LittleEndianOutputStream[]{tempLOS};
        this.writeMatrix2(wholeGenomeMatrix, localLos, WriterUtils.getDefaultCompressor(), this.localMatrixPositions, 0, this.outputFile);
        this.nonemptyChromosomePairs.put(0, 1);
        long currentPosition = this.losArray[0].getWrittenCount();
        for (int i3 = 0; i3 < this.chromosomePairCounter; ++i3) {
            if (!this.nonemptyChromosomePairs.containsKey(i3) || !this.chromosomePairBlockIndexes.containsKey(i3)) continue;
            for (Map.Entry<Long, List<IndexEntry>> entry : this.chromosomePairBlockIndexes.get(i3).entrySet()) {
                MultithreadedPreprocessor.updateIndexPositions(entry.getValue(), null, false, new File(this.outputFile + "_" + this.chromosomePairIndexes.get(i3)), currentPosition, entry.getKey());
            }
            long nextMatrixPosition = this.localMatrixPositions.get((Object)new StringBuilder().append((String)"").append((int)i3).toString()).position + currentPosition;
            String currentMatrixKey = this.chromosomePairIndex1.get(i3) + "_" + this.chromosomePairIndex2.get(i3);
            this.matrixPositions.put(currentMatrixKey, new IndexEntry(nextMatrixPosition, this.localMatrixPositions.get((Object)new StringBuilder().append((String)"").append((int)i3).toString()).size));
            currentPosition += this.matrixSizes.get(i3).longValue();
        }
        this.masterIndexPosition = currentPosition;
    }

    private void writeIndividualMatrix(Integer chromosomePair, int numOfNeededThreads) throws IOException {
        LittleEndianOutputStream[] localLos;
        int chr1 = this.chromosomePairIndex1.get(chromosomePair);
        int chr2 = this.chromosomePairIndex2.get(chromosomePair);
        if (this.includedChromosomes != null) {
            String c1Name = this.chromosomeHandler.getChromosomeFromIndex(chr1).getName();
            String c2Name = this.chromosomeHandler.getChromosomeFromIndex(chr2).getName();
            if (this.includedChromosomes.contains(c1Name) || this.includedChromosomes.contains(c2Name)) {
                this.nonemptyChromosomePairs.put(chromosomePair, 1);
            }
        } else {
            this.nonemptyChromosomePairs.put(chromosomePair, 1);
        }
        if (numOfNeededThreads == 1) {
            localLos = new LittleEndianOutputStream[]{new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(this.outputFile + "_" + this.chromosomePairIndexes.get(chromosomePair)), 0x200000))};
        } else {
            localLos = new LittleEndianOutputStream[numOfNeededThreads * this.numResolutions + 1];
            localLos[0] = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(this.outputFile + "_" + this.chromosomePairIndexes.get(chromosomePair)), 0x200000));
            for (int i = 1; i <= numOfNeededThreads * this.numResolutions; ++i) {
                localLos[i] = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(this.outputFile + "_" + this.chromosomePairIndexes.get(chromosomePair) + "_" + i), 0x200000));
            }
        }
        this.writeMatrix2(this.finalChrMatrices.get(chromosomePair), localLos, WriterUtils.getDefaultCompressor(), this.localMatrixPositions, chromosomePair, this.outputFile);
    }

    protected Pair<Map<Long, List<IndexEntry>>, Long> writeMatrix2(MatrixPP matrix, LittleEndianOutputStream[] localLos, Deflater localCompressor, Map<String, IndexEntry> localMatrixPositions, int chromosomePairIndex, File outputFile) throws IOException {
        Pair<Map<Long, List<IndexEntry>>, Long> localBlockIndexes = MultithreadedPreprocessor.writeMatrix(matrix, localLos, localCompressor, localMatrixPositions, chromosomePairIndex, true, outputFile);
        this.chromosomePairBlockIndexes.put(chromosomePairIndex, localBlockIndexes.getFirst());
        long size = -localBlockIndexes.getSecond().longValue();
        for (LittleEndianOutputStream localLo : localLos) {
            size += localLo.getWrittenCount();
            localLo.close();
        }
        this.matrixSizes.put(chromosomePairIndex, size);
        return localBlockIndexes;
    }
}

