/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.original;

import com.google.common.util.concurrent.AtomicDouble;
import hic.tools.utils.original.BlockPP;
import hic.tools.utils.original.BlockQueue;
import hic.tools.utils.original.BlockQueueFB;
import hic.tools.utils.original.BlockQueueMem;
import hic.tools.utils.original.ExpectedValueCalculation;
import hic.tools.utils.original.IndexEntry;
import hic.tools.utils.original.RecordBlockUtils;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.awt.Point;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.Deflater;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.depth.V9Depth;
import javastraw.tools.ParallelizationTools;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.broad.igv.tdf.BufferedByteWriter;
import org.broad.igv.util.collections.DownsampledDoubleArrayList;

public class MatrixZoomDataPP {
    final Set<Integer> blockNumbers;
    final ConcurrentHashMap<Integer, Integer> blockNumRecords;
    final List<File> tmpFiles = new ArrayList<File>();
    final Map<Integer, Map<File, Long>> tmpFilesByBlockNumber = new ConcurrentHashMap<Integer, Map<File, Long>>();
    private final Chromosome chr1;
    private final Chromosome chr2;
    private final int zoom;
    private final int binSize;
    private final int blockBinCount;
    private final int blockColumnCount;
    private final LinkedHashMap<Integer, BlockPP> blocks;
    private final int countThreshold;
    long blockIndexPosition;
    private final AtomicDouble sum = new AtomicDouble(0.0);
    private double numRecords = 0.0;
    private final AtomicDouble cellCount = new AtomicDouble(0.0);
    private double percent5;
    private double percent95;
    private final int blockCapacity;
    private final V9Depth v9Depth;

    MatrixZoomDataPP(Chromosome chr1, Chromosome chr2, int binSize, int blockColumnCount, int zoom, int countThreshold, int v9BaseDepth, int blockCapacity) {
        this.blockCapacity = blockCapacity;
        this.blockNumbers = Collections.synchronizedSet(new HashSet(blockCapacity));
        this.blockNumRecords = new ConcurrentHashMap(blockCapacity);
        this.countThreshold = countThreshold;
        this.chr1 = chr1;
        this.chr2 = chr2;
        this.binSize = binSize;
        this.blockColumnCount = blockColumnCount;
        this.zoom = zoom;
        Chromosome longChr = chr1.getLength() > chr2.getLength() ? chr1 : chr2;
        long len = longChr.getLength();
        int nBinsX = (int)(len / (long)binSize + 1L);
        this.blockBinCount = nBinsX / blockColumnCount + 1;
        this.blocks = new LinkedHashMap(blockColumnCount);
        this.v9Depth = V9Depth.setDepthMethod(v9BaseDepth, this.blockBinCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeBlock(BlockPP block, DownsampledDoubleArrayList sampledData, LittleEndianOutputStream los, Deflater compressor, int countThreshold, AtomicDouble cellCount, AtomicDouble sum) throws IOException {
        Map<Point, Float> records = block.getContactRecordMap();
        int nRecords = RecordBlockUtils.getNumberOfRecords(records, countThreshold);
        BufferedByteWriter buffer = new BufferedByteWriter(nRecords * 12);
        buffer.putInt(nRecords);
        cellCount.addAndGet(nRecords);
        int binXOffset = Integer.MAX_VALUE;
        int binYOffset = Integer.MAX_VALUE;
        int binXMax = 0;
        int binYMax = 0;
        for (Map.Entry<Point, Float> entry : records.entrySet()) {
            Point point = entry.getKey();
            binXOffset = Math.min(binXOffset, point.x);
            binYOffset = Math.min(binYOffset, point.y);
            binXMax = Math.max(binXMax, point.x);
            binYMax = Math.max(binYMax, point.y);
        }
        buffer.putInt(binXOffset);
        buffer.putInt(binYOffset);
        ArrayList<Point> keys2 = new ArrayList<Point>(records.keySet());
        keys2.sort((o1, o2) -> {
            if (o1.y != o2.y) {
                return o1.y - o2.y;
            }
            return o1.x - o2.x;
        });
        Point lastPoint = (Point)keys2.get(keys2.size() - 1);
        short w = (short)(binXMax - binXOffset + 1);
        int w1 = binXMax - binXOffset + 1;
        int w2 = binYMax - binYOffset + 1;
        boolean isInteger = true;
        float maxCounts = 0.0f;
        LinkedHashMap rows = new LinkedHashMap();
        for (Point point : keys2) {
            float counts = records.get(point).floatValue();
            if (!(counts >= (float)countThreshold)) continue;
            isInteger = isInteger && Math.floor(counts) == (double)counts;
            maxCounts = Math.max(counts, maxCounts);
            int px = point.x - binXOffset;
            int py = point.y - binYOffset;
            if (!rows.containsKey(py)) {
                rows.put(py, new ArrayList(10));
            }
            ((List)rows.get(py)).add(new ContactRecord(px, py, counts));
        }
        boolean useShort = isInteger && maxCounts < 32767.0f;
        boolean useShortBinX = w1 < Short.MAX_VALUE;
        boolean useShortBinY = w2 < Short.MAX_VALUE;
        int valueSize = useShort ? 2 : 4;
        int lorSize = 0;
        int nDensePts = (lastPoint.y - binYOffset) * w + (lastPoint.x - binXOffset) + 1;
        for (Object row : rows.values()) {
            lorSize += 4 + row.size() * valueSize;
        }
        buffer.put((byte)(!useShort ? 1 : 0));
        buffer.put((byte)(!useShortBinX ? 1 : 0));
        buffer.put((byte)(!useShortBinY ? 1 : 0));
        int denseSize = Integer.MAX_VALUE;
        if (lorSize < denseSize) {
            buffer.put(1);
            MatrixZoomDataPP.putShortOrIntInBuffer(buffer, rows.size(), useShortBinY);
            for (Map.Entry entry : rows.entrySet()) {
                int py = (Integer)entry.getKey();
                List row = (List)entry.getValue();
                MatrixZoomDataPP.putShortOrIntInBuffer(buffer, py, useShortBinY);
                MatrixZoomDataPP.putShortOrIntInBuffer(buffer, row.size(), useShortBinX);
                for (ContactRecord contactRecord : row) {
                    MatrixZoomDataPP.putShortOrIntInBuffer(buffer, contactRecord.getBinX(), useShortBinX);
                    float counts = contactRecord.getCounts();
                    MatrixZoomDataPP.putShortOrFloatInBuffer(buffer, counts, useShort);
                    DownsampledDoubleArrayList downsampledDoubleArrayList = sampledData;
                    synchronized (downsampledDoubleArrayList) {
                        sampledData.add(counts);
                    }
                    sum.addAndGet(counts);
                }
            }
        } else {
            buffer.put(2);
            buffer.putInt(nDensePts);
            buffer.putShort(w);
            int lastIdx = 0;
            for (Point p : keys2) {
                int idx = (p.y - binYOffset) * w + (p.x - binXOffset);
                for (int i = lastIdx; i < idx; ++i) {
                    if (useShort) {
                        buffer.putShort((short)Short.MIN_VALUE);
                        continue;
                    }
                    buffer.putFloat(Float.NaN);
                }
                float counts = records.get(p).floatValue();
                MatrixZoomDataPP.putShortOrFloatInBuffer(buffer, counts, useShort);
                lastIdx = idx + 1;
                DownsampledDoubleArrayList downsampledDoubleArrayList = sampledData;
                synchronized (downsampledDoubleArrayList) {
                    sampledData.add(counts);
                }
                sum.addAndGet(counts);
            }
        }
        byte[] bytes2 = buffer.getBytes();
        byte[] byArray = RecordBlockUtils.compress(bytes2, compressor);
        los.write(byArray);
    }

    private static void putShortOrFloatInBuffer(BufferedByteWriter buffer, float value, boolean useShort) throws IOException {
        if (useShort) {
            buffer.putShort((short)value);
        } else {
            buffer.putFloat(value);
        }
    }

    private static void putShortOrIntInBuffer(BufferedByteWriter buffer, int value, boolean useShort) throws IOException {
        if (useShort) {
            buffer.putShort((short)value);
        } else {
            buffer.putInt(value);
        }
    }

    double getSum() {
        return this.sum.get();
    }

    double getPercent95() {
        return this.percent95;
    }

    double getPercent5() {
        return this.percent5;
    }

    int getBinSize() {
        return this.binSize;
    }

    int getZoom() {
        return this.zoom;
    }

    int getBlockBinCount() {
        return this.blockBinCount;
    }

    int getBlockColumnCount() {
        return this.blockColumnCount;
    }

    double getOccupiedCellCount() {
        return this.cellCount.get();
    }

    void incrementCount(int pos1, int pos2, float score, Map<String, ExpectedValueCalculation> expectedValueCalculations, File tmpDir) throws IOException {
        if (pos1 < 0 || pos2 < 0) {
            return;
        }
        this.sum.addAndGet(score);
        int xBin = pos1 / this.binSize;
        int yBin = pos2 / this.binSize;
        this.commonIncrementCount(xBin, yBin, score, expectedValueCalculations, tmpDir);
    }

    private void commonIncrementCount(int xBin0, int yBin0, float score, Map<String, ExpectedValueCalculation> expectedValueCalculations, File tmpDir) throws IOException {
        int blockNumber;
        int xBin = xBin0;
        int yBin = yBin0;
        if (this.chr1.equals(this.chr2)) {
            String evKey;
            ExpectedValueCalculation ev;
            xBin = Math.min(xBin0, yBin0);
            if (xBin != (yBin = Math.max(xBin0, yBin0))) {
                this.sum.addAndGet(score);
            }
            if (expectedValueCalculations != null && (ev = expectedValueCalculations.get(evKey = "BP_" + this.binSize)) != null) {
                ev.addDistance(this.chr1.getIndex(), xBin, yBin, score);
            }
            int depth = this.v9Depth.getDepth(xBin, yBin);
            int positionAlongDiagonal = (xBin + yBin) / 2 / this.blockBinCount;
            blockNumber = depth * this.blockColumnCount + positionAlongDiagonal;
        } else {
            int blockCol = xBin0 / this.blockBinCount;
            int blockRow = yBin0 / this.blockBinCount;
            blockNumber = this.blockColumnCount * blockRow + blockCol;
        }
        BlockPP block = this.blocks.get(blockNumber);
        if (block == null) {
            block = new BlockPP(blockNumber);
            this.blocks.put(blockNumber, block);
        }
        block.incrementCount(xBin, yBin, score);
        if (this.blocks.size() > this.blockCapacity) {
            File tmpFile = tmpDir == null ? File.createTempFile("blocks", "bin") : File.createTempFile("blocks", "bin", tmpDir);
            this.dumpBlocks(tmpFile);
            this.tmpFiles.add(tmpFile);
            tmpFile.deleteOnExit();
        }
    }

    protected List<IndexEntry> mergeAndWriteBlocksMT(LittleEndianOutputStream[] losArray, int whichZoom, int numResolutions) {
        DownsampledDoubleArrayList sampledData = new DownsampledDoubleArrayList(10000, 10000);
        Object[] sortedBlockNumbers = new Integer[this.blockNumbers.size()];
        this.blockNumbers.toArray(sortedBlockNumbers);
        Arrays.sort(sortedBlockNumbers);
        ConcurrentHashMap<Integer, BlockPP> threadSafeBlocks = new ConcurrentHashMap<Integer, BlockPP>(this.blocks.size());
        threadSafeBlocks.putAll(this.blocks);
        int numCPUThreads = (losArray.length - 1) / numResolutions;
        ExecutorService executor = Executors.newFixedThreadPool(numCPUThreads);
        ConcurrentHashMap<Integer, Long> blockChunkSizes = new ConcurrentHashMap<Integer, Long>(numCPUThreads);
        ConcurrentHashMap chunkBlockIndexes = new ConcurrentHashMap(numCPUThreads);
        int startBlock = 0;
        int endBlock = 0;
        for (int threadNum = 0; threadNum < numCPUThreads; ++threadNum) {
            int whichLos = numCPUThreads * whichZoom + threadNum;
            int numOfRecordsPerThread = 2 * (int)Math.floor(this.numRecords / (double)numCPUThreads);
            int maxNumOfBlocksPerThread = (int)Math.floor((double)sortedBlockNumbers.length / (double)numCPUThreads);
            if (threadNum > 0) {
                startBlock = endBlock;
            }
            int numOfRecords = 0;
            for (int i = startBlock; i < sortedBlockNumbers.length; ++i) {
                if ((numOfRecords += this.blockNumRecords.get(sortedBlockNumbers[i]).intValue()) <= numOfRecordsPerThread && i - startBlock <= maxNumOfBlocksPerThread) continue;
                endBlock = i;
                break;
            }
            if (threadNum + 1 == numCPUThreads && endBlock < sortedBlockNumbers.length) {
                endBlock = sortedBlockNumbers.length;
            }
            if (startBlock >= endBlock) {
                blockChunkSizes.put(threadNum, 0L);
                continue;
            }
            Integer[] threadBlocks = (Integer[])Arrays.copyOfRange(sortedBlockNumbers, startBlock, endBlock);
            ArrayList indexEntries = new ArrayList();
            Runnable worker = () -> {
                try {
                    this.writeBlockChunk(threadBlocks, threadSafeBlocks, losArray, whichLos, indexEntries, sampledData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                chunkBlockIndexes.put(whichLos, indexEntries);
            };
            executor.execute(worker);
        }
        ParallelizationTools.shutDownAndWaitUntilDone(executor, 1000);
        long adjust = 0L;
        for (int i = 0; i < losArray.length; ++i) {
            blockChunkSizes.put(i, losArray[i].getWrittenCount());
            if (i >= numCPUThreads * whichZoom) continue;
            adjust += ((Long)blockChunkSizes.get(i)).longValue();
        }
        ArrayList<IndexEntry> finalIndexEntries = new ArrayList<IndexEntry>();
        for (int i = numCPUThreads * whichZoom; i < numCPUThreads * (whichZoom + 1); ++i) {
            adjust += ((Long)blockChunkSizes.get(i)).longValue();
            if (chunkBlockIndexes.get(i) == null) continue;
            for (int j = 0; j < ((List)chunkBlockIndexes.get(i)).size(); ++j) {
                finalIndexEntries.add(new IndexEntry(((IndexEntry)((List)chunkBlockIndexes.get((Object)Integer.valueOf((int)i))).get((int)j)).id, ((IndexEntry)((List)chunkBlockIndexes.get((Object)Integer.valueOf((int)i))).get((int)j)).position + adjust, ((IndexEntry)((List)chunkBlockIndexes.get((Object)Integer.valueOf((int)i))).get((int)j)).size));
            }
        }
        for (File f : this.tmpFiles) {
            boolean result = f.delete();
            if (result) continue;
            System.out.println("Error while deleting file");
        }
        this.computeStats(sampledData);
        return finalIndexEntries;
    }

    protected List<IndexEntry> mergeAndWriteBlocksST(LittleEndianOutputStream los, Deflater compressor) throws IOException {
        DownsampledDoubleArrayList sampledData = new DownsampledDoubleArrayList(10000, 10000);
        ArrayList<Object> activeList = new ArrayList<Object>();
        if (this.blocks.size() > 0) {
            BlockQueueMem bqInMem = new BlockQueueMem(this.blocks.values());
            activeList.add(bqInMem);
        }
        for (File file : this.tmpFiles) {
            BlockQueueFB bq = new BlockQueueFB(file);
            if (bq.getBlock() == null) continue;
            activeList.add(bq);
        }
        if (activeList.size() == 0) {
            throw new RuntimeException("No reads in Hi-C contact matrices. This could be because the MAP-Q filter is set too high (-q) or because all reads map to the same fragment.");
        }
        ArrayList<IndexEntry> indexEntries = new ArrayList<IndexEntry>();
        do {
            activeList.sort(Comparator.comparingInt(o -> o.getBlock().getNumber()));
            BlockQueue topQueue = (BlockQueue)activeList.get(0);
            BlockPP currentBlock = topQueue.getBlock();
            topQueue.advance();
            int num = currentBlock.getNumber();
            for (int i = 1; i < activeList.size(); ++i) {
                BlockQueue blockQueue2 = (BlockQueue)activeList.get(i);
                BlockPP block = blockQueue2.getBlock();
                if (block.getNumber() != num) continue;
                currentBlock.merge(block);
                blockQueue2.advance();
            }
            activeList.removeIf(blockQueue -> blockQueue.getBlock() == null);
            long position = los.getWrittenCount();
            MatrixZoomDataPP.writeBlock(currentBlock, sampledData, los, compressor, this.countThreshold, this.cellCount, this.sum);
            long size = los.getWrittenCount() - position;
            indexEntries.add(new IndexEntry(num, position, (int)size));
        } while (activeList.size() > 0);
        for (File f : this.tmpFiles) {
            boolean result = f.delete();
            if (result) continue;
            System.out.println("Error while deleting file");
        }
        this.computeStats(sampledData);
        return indexEntries;
    }

    private void dumpBlocks(File file) throws IOException {
        try (LittleEndianOutputStream los = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(file), 0x400000));){
            ArrayList<BlockPP> blockList = new ArrayList<BlockPP>(this.blocks.values());
            blockList.sort(Comparator.comparingInt(BlockPP::getNumber));
            for (BlockPP b : blockList) {
                this.blocks.remove(b.getNumber());
                int number = this.addToBlockAndRecordsSets(b);
                if (this.tmpFilesByBlockNumber.get(number) == null) {
                    this.tmpFilesByBlockNumber.put(number, new ConcurrentHashMap());
                }
                this.tmpFilesByBlockNumber.get(number).put(file, los.getWrittenCount());
                los.writeInt(number);
                Map<Point, Float> records = b.getContactRecordMap();
                los.writeInt(records.size());
                for (Point point : records.keySet()) {
                    Float count = records.get(point);
                    los.writeInt(point.x);
                    los.writeInt(point.y);
                    los.writeFloat(count.floatValue());
                }
            }
            this.blocks.clear();
        }
    }

    private void computeStats(DownsampledDoubleArrayList sampledData) {
        DescriptiveStatistics stats = new DescriptiveStatistics(sampledData.toArray());
        this.percent5 = stats.getPercentile(5.0);
        this.percent95 = stats.getPercentile(95.0);
    }

    void parsingComplete() {
        for (BlockPP block : this.blocks.values()) {
            this.addToBlockAndRecordsSets(block);
        }
    }

    private void writeBlockChunk(Integer[] threadBlocks, Map<Integer, BlockPP> threadSafeBlocks, LittleEndianOutputStream[] losArray, int threadNum, List<IndexEntry> indexEntries, DownsampledDoubleArrayList sampledData) throws IOException {
        Deflater compressor = new Deflater();
        compressor.setLevel(-1);
        for (int i = 0; i < threadBlocks.length; ++i) {
            Map.Entry<File, Long> firstEntry;
            Iterator<Map.Entry<File, Long>> iter;
            BlockPP currentBlock = null;
            int num = threadBlocks[i];
            if (threadSafeBlocks.get(num) != null) {
                currentBlock = threadSafeBlocks.get(num);
                if (this.tmpFilesByBlockNumber.get(num) != null) {
                    for (Map.Entry<File, Long> entry : this.tmpFilesByBlockNumber.get(num).entrySet()) {
                        RecordBlockUtils.readAndMerge(currentBlock, entry);
                    }
                }
            } else if (this.tmpFilesByBlockNumber.get(num) != null && (iter = this.tmpFilesByBlockNumber.get(num).entrySet().iterator()).hasNext() && (currentBlock = RecordBlockUtils.readTmpBlock((firstEntry = iter.next()).getKey(), firstEntry.getValue())) != null) {
                while (iter.hasNext()) {
                    RecordBlockUtils.readAndMerge(currentBlock, iter.next());
                }
            }
            if (currentBlock == null) continue;
            long position = losArray[threadNum + 1].getWrittenCount();
            MatrixZoomDataPP.writeBlock(currentBlock, sampledData, losArray[threadNum + 1], compressor, this.countThreshold, this.cellCount, this.sum);
            long size = losArray[threadNum + 1].getWrittenCount() - position;
            indexEntries.add(new IndexEntry(num, position, (int)size));
        }
    }

    void mergeMatrices(MatrixZoomDataPP otherMatrixZoom) {
        this.sum.addAndGet(otherMatrixZoom.sum.get());
        this.numRecords += otherMatrixZoom.numRecords;
        Iterator<Object> iterator2 = otherMatrixZoom.blocks.keySet().iterator();
        while (iterator2.hasNext()) {
            int n = iterator2.next();
            BlockPP otherBlock = otherMatrixZoom.blocks.get(n);
            if (this.blocks.containsKey(n)) {
                BlockPP block = this.blocks.get(n);
                block.merge(otherBlock);
                this.blockNumRecords.put(n, block.getNumRecords());
                continue;
            }
            this.blocks.put(n, otherBlock);
            this.blockNumbers.add(n);
        }
        iterator2 = otherMatrixZoom.blockNumbers.iterator();
        while (iterator2.hasNext()) {
            int n = iterator2.next();
            this.blockNumbers.add(n);
            if (this.blockNumRecords.containsKey(n)) {
                this.blockNumRecords.put(n, this.blockNumRecords.get(n) + otherMatrixZoom.blockNumRecords.get(n));
                continue;
            }
            this.blockNumRecords.put(n, otherMatrixZoom.blockNumRecords.get(n));
        }
        this.tmpFiles.addAll(otherMatrixZoom.tmpFiles);
        for (Map.Entry entry : otherMatrixZoom.tmpFilesByBlockNumber.entrySet()) {
            if (this.tmpFilesByBlockNumber.containsKey(entry.getKey())) {
                for (Map.Entry tmpFile : ((Map)entry.getValue()).entrySet()) {
                    this.tmpFilesByBlockNumber.get(entry.getKey()).put((File)tmpFile.getKey(), (Long)tmpFile.getValue());
                }
                continue;
            }
            this.tmpFilesByBlockNumber.put((Integer)entry.getKey(), (Map<File, Long>)entry.getValue());
        }
    }

    private int addToBlockAndRecordsSets(BlockPP b) {
        int number = b.getNumber();
        this.blockNumbers.add(number);
        if (this.blockNumRecords.containsKey(number)) {
            this.blockNumRecords.put(number, b.getNumRecords() + this.blockNumRecords.get(number));
        } else {
            this.blockNumRecords.put(number, b.getNumRecords());
        }
        this.numRecords += (double)b.getNumRecords();
        return number;
    }
}

