/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.original;

import hic.tools.utils.iterators.contacts.Contact;
import hic.tools.utils.original.ExpectedValueCalculation;
import hic.tools.utils.original.MatrixZoomDataPP;
import hic.tools.utils.original.Preprocessor;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;

public class MatrixPP {
    private static final int INTRA_CUTOFF = 500;
    private static final int INTER_CUTOFF = 5000;
    private final int MAX_SQRT = (int)Math.sqrt(2.147483647E9);
    private final int chr1Idx;
    private final int chr2Idx;
    private final MatrixZoomDataPP[] zoomData;

    public MatrixPP(int chr1Idx, int chr2Idx, ChromosomeHandler chromosomeHandler, int[] bpBinSizes, int countThreshold, int v9DepthBase, int BLOCK_CAPACITY) {
        this.chr1Idx = chr1Idx;
        this.chr2Idx = chr2Idx;
        int nResolutions = bpBinSizes.length;
        this.zoomData = new MatrixZoomDataPP[nResolutions];
        int zoom = 0;
        for (int idx = 0; idx < bpBinSizes.length; ++idx) {
            int binSize = bpBinSizes[zoom];
            Chromosome chrom1 = chromosomeHandler.getChromosomeFromIndex(chr1Idx);
            Chromosome chrom2 = chromosomeHandler.getChromosomeFromIndex(chr2Idx);
            long len = Math.max(chrom1.getLength(), chrom2.getLength());
            int nBins = (int)(len / (long)binSize + 1L);
            int nColumns = chrom1.equals(chrom2) ? this.getNumColumnsFromNumBins(nBins, binSize, 500) : this.getNumColumnsFromNumBins(nBins, binSize, 5000);
            this.zoomData[idx] = new MatrixZoomDataPP(chrom1, chrom2, binSize, nColumns, zoom, countThreshold, v9DepthBase, BLOCK_CAPACITY);
            ++zoom;
        }
    }

    MatrixPP(int chr1Idx, int chr2Idx, int binSize, int blockColumnCount, ChromosomeHandler chromosomeHandler, int countThreshold, int v9DepthBase) {
        this.chr1Idx = chr1Idx;
        this.chr2Idx = chr2Idx;
        this.zoomData = new MatrixZoomDataPP[1];
        this.zoomData[0] = new MatrixZoomDataPP(chromosomeHandler.getChromosomeFromIndex(chr1Idx), chromosomeHandler.getChromosomeFromIndex(chr2Idx), binSize, blockColumnCount, 0, countThreshold, v9DepthBase, Preprocessor.BLOCK_CAPACITY);
    }

    private int getNumColumnsFromNumBins(int nBins, int binSize, int cutoff) {
        int nColumns = nBins / Preprocessor.BLOCK_CAPACITY + 1;
        if (binSize < cutoff) {
            long numerator = (long)nBins * (long)binSize;
            long denominator = (long)Preprocessor.BLOCK_CAPACITY * (long)cutoff;
            nColumns = (int)(numerator / denominator) + 1;
        }
        return Math.min(nColumns, this.MAX_SQRT - 1);
    }

    String getKey() {
        return this.chr1Idx + "_" + this.chr2Idx;
    }

    public void incrementCount(Contact contact, Map<String, ExpectedValueCalculation> expectedValueCalculations, File tmpDir) throws IOException {
        this.incrementCount(contact.getPos1(), contact.getPos2(), contact.getScore(), expectedValueCalculations, tmpDir);
    }

    public void incrementCount(int pos1, int pos2, float score, Map<String, ExpectedValueCalculation> expectedValueCalculations, File tmpDir) throws IOException {
        for (MatrixZoomDataPP aZoomData : this.zoomData) {
            aZoomData.incrementCount(pos1, pos2, score, expectedValueCalculations, tmpDir);
        }
    }

    public void parsingComplete() {
        for (MatrixZoomDataPP zd : this.zoomData) {
            if (zd == null) continue;
            zd.parsingComplete();
        }
    }

    int getChr1Idx() {
        return this.chr1Idx;
    }

    int getChr2Idx() {
        return this.chr2Idx;
    }

    MatrixZoomDataPP[] getZoomData() {
        return this.zoomData;
    }

    public void mergeMatrices(MatrixPP otherMatrix) {
        if (otherMatrix != null) {
            for (MatrixZoomDataPP aZoomData : this.zoomData) {
                for (MatrixZoomDataPP bZoomData : otherMatrix.zoomData) {
                    if (aZoomData.getZoom() != bZoomData.getZoom()) continue;
                    aZoomData.mergeMatrices(bZoomData);
                }
            }
        }
    }
}

