/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.original;

import hic.tools.utils.original.Chunk;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javastraw.reader.basics.ChromosomeHandler;

public class MTIndexHandler {
    public static Map<Integer, List<Chunk>> readMndIndex(String mndIndexFile, Map<Integer, String> chromosomePairIndexes) {
        HashMap tempIndex = new HashMap();
        ConcurrentHashMap<Integer, List<Chunk>> mndIndex = new ConcurrentHashMap<Integer, List<Chunk>>();
        try {
            String nextLine;
            FileInputStream is = new FileInputStream(mndIndexFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is), 0x200000);
            while ((nextLine = reader.readLine()) != null) {
                String[] nextEntry = nextLine.split(",");
                if (nextEntry.length == 4) {
                    if (tempIndex.get(nextEntry[0]) == null) {
                        tempIndex.put(nextEntry[0], new ArrayList());
                    }
                    Chunk indexEntry = new Chunk(nextEntry[2], nextEntry[3]);
                    ((List)tempIndex.get(nextEntry[0])).add(indexEntry);
                    continue;
                }
                System.err.println("Improperly formatted merged nodups index: " + nextLine);
                System.exit(70);
            }
            if (tempIndex.isEmpty()) {
                System.err.println("Intermediate MNDIndex is empty or could not be read");
                System.exit(44);
            }
        }
        catch (Exception e) {
            System.err.println("Unable to read merged nodups index");
            System.exit(70);
        }
        for (Map.Entry<Integer, String> entry : chromosomePairIndexes.entrySet()) {
            String reverseName = entry.getValue().split("-")[1] + "-" + entry.getValue().split("-")[0];
            if (tempIndex.containsKey(entry.getValue())) {
                mndIndex.put(entry.getKey(), (List<Chunk>)tempIndex.get(entry.getValue()));
                continue;
            }
            if (tempIndex.containsKey(reverseName)) {
                mndIndex.put(entry.getKey(), (List<Chunk>)tempIndex.get(reverseName));
                continue;
            }
            if (reverseName.equalsIgnoreCase("all")) continue;
            System.err.println("Unable to find " + entry.getValue() + "  or  " + reverseName);
        }
        if (mndIndex.isEmpty()) {
            System.err.println("MNDIndex is empty or could not be read");
            System.exit(43);
        }
        return mndIndex;
    }

    public static Map<String, Integer> populateChromosomeIndexes(ChromosomeHandler chromosomeHandler, int numCPUThreads) {
        ConcurrentHashMap<String, Integer> chromosomeIndexes = new ConcurrentHashMap<String, Integer>(chromosomeHandler.size(), 0.75f, numCPUThreads);
        for (int i = 0; i < chromosomeHandler.size(); ++i) {
            chromosomeIndexes.put(chromosomeHandler.getChromosomeFromIndex(i).getName(), i);
        }
        return chromosomeIndexes;
    }

    public static int populateChromosomePairIndexes(ChromosomeHandler chromosomeHandler, Map<Integer, String> chromosomePairIndexes, Map<String, Integer> chromosomePairIndexesReverse, Map<Integer, Integer> chromosomePairIndex1, Map<Integer, Integer> chromosomePairIndex2) {
        int chromosomePairCounter = 0;
        String genomeWideName = chromosomeHandler.getChromosomeFromIndex(0).getName();
        String genomeWidePairName = genomeWideName + "-" + genomeWideName;
        chromosomePairIndexes.put(chromosomePairCounter, genomeWidePairName);
        chromosomePairIndexesReverse.put(genomeWidePairName, chromosomePairCounter);
        chromosomePairIndex1.put(chromosomePairCounter, 0);
        chromosomePairIndex2.put(chromosomePairCounter, 0);
        ++chromosomePairCounter;
        for (int i = 1; i < chromosomeHandler.size(); ++i) {
            for (int j = i; j < chromosomeHandler.size(); ++j) {
                String c1Name = chromosomeHandler.getChromosomeFromIndex(i).getName();
                String c2Name = chromosomeHandler.getChromosomeFromIndex(j).getName();
                String chromosomePairName = c1Name + "-" + c2Name;
                chromosomePairIndexes.put(chromosomePairCounter, chromosomePairName);
                chromosomePairIndexesReverse.put(chromosomePairName, chromosomePairCounter);
                chromosomePairIndex1.put(chromosomePairCounter, i);
                chromosomePairIndex2.put(chromosomePairCounter, j);
                ++chromosomePairCounter;
            }
        }
        return chromosomePairCounter;
    }
}

