/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.original;

import hic.tools.utils.iterators.mnd.ReadPairFilter;
import hic.tools.utils.largelists.BigListOfByteWriters;
import hic.tools.utils.original.ExpectedValueCalculation;
import hic.tools.utils.original.IndexEntry;
import hic.tools.utils.original.MatrixPP;
import hic.tools.utils.original.MatrixZoomDataPP;
import hic.tools.utils.original.WriterUtils;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.Deflater;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.basics.ChromosomeTools;
import javastraw.reader.datastructures.ListOfDoubleArrays;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationHandler;
import javastraw.tools.UNIXTools;
import org.broad.igv.tdf.BufferedByteWriter;
import org.broad.igv.util.Pair;

public abstract class HiCFileBuilder {
    protected long masterIndexPositionPosition;
    protected long normVectorIndexPosition;
    protected long normVectorLengthPosition;
    protected Map<String, ExpectedValueCalculation> expectedValueCalculations = Collections.synchronizedMap(new LinkedHashMap());
    private static final int TEN_MB = 10000000;
    protected static final int VERSION = 9;
    public static int BLOCK_CAPACITY = 1000;
    protected final ChromosomeHandler chromosomeHandler;
    protected final File outputFile;
    protected final Map<String, IndexEntry> matrixPositions = new LinkedHashMap<String, IndexEntry>();
    protected final Deflater compressor = WriterUtils.getDefaultCompressor();
    protected int v9DepthBase = 2;
    protected Map<String, Integer> chromosomeIndexes = new ConcurrentHashMap<String, Integer>();
    protected String genomeId;
    protected final LittleEndianOutputStream[] losArray = new LittleEndianOutputStream[1];
    protected long masterIndexPosition;
    protected int countThreshold = 0;
    protected int mapqThreshold = 0;
    protected boolean intraChromosomalOnly = false;
    protected boolean onlyNearDiagonalContacts = false;
    protected String statsFileName = null;
    protected String graphFileName = null;
    protected Set<String> includedChromosomes;
    protected ReadPairFilter filter = null;
    protected int[] bpBinSizes = new int[]{2500000, 1000000, 500000, 250000, 100000, 50000, 25000, 10000, 5000, 1000};
    protected int numResolutions;
    protected double hicFileScalingFactor = 1.0;
    protected final File tmpDir;

    public HiCFileBuilder(File outputFile, String genomeId, double hicFileScalingFactor, String tmpDir) {
        this.genomeId = genomeId;
        this.outputFile = outputFile;
        this.chromosomeHandler = ChromosomeTools.loadChromosomes(genomeId);
        for (int i = 0; i < this.chromosomeHandler.size(); ++i) {
            this.chromosomeIndexes.put(this.chromosomeHandler.getChromosomeFromIndex(i).getName(), i);
        }
        if (hicFileScalingFactor > 0.0) {
            this.hicFileScalingFactor = hicFileScalingFactor;
        }
        this.tmpDir = tmpDir != null && tmpDir.length() > 1 ? UNIXTools.makeDir(new File(tmpDir)) : UNIXTools.makeDir(new File("temp_folder"));
        this.tmpDir.deleteOnExit();
        this.initializeExpectedVectorCalculations();
    }

    protected static void closeLosArray(LittleEndianOutputStream[] los) throws IOException {
        if (los != null && los[0] != null) {
            los[0].close();
        }
    }

    public void setCountThreshold(int countThreshold) {
        this.countThreshold = countThreshold;
    }

    public void setV9DepthBase(int v9DepthBase) {
        if (v9DepthBase > 1 || v9DepthBase < 0) {
            this.v9DepthBase = v9DepthBase;
        }
    }

    public void setMapqThreshold(int mapqThreshold) {
        this.mapqThreshold = mapqThreshold;
    }

    public static boolean tooFarFromDiagonal(int pos1, int pos2) {
        return Math.abs(pos1 - pos2) > 10000000;
    }

    protected static boolean tooFarFromDiagonal(long pos1, long pos2) {
        return Math.abs(pos1 - pos2) > 10000000L;
    }

    public void setIntraChromosomalOnly(boolean intraChromosomalOnly) {
        this.intraChromosomalOnly = intraChromosomalOnly;
    }

    public void setOnlyNearDiagonalsOnly(boolean getOnlyNearDiagonal) {
        this.onlyNearDiagonalContacts = getOnlyNearDiagonal;
    }

    public void setIncludedChromosomes(Set<String> includedChromosomes) {
        if (includedChromosomes != null && includedChromosomes.size() > 0) {
            this.includedChromosomes = Collections.synchronizedSet(new HashSet());
            for (String name : includedChromosomes) {
                this.includedChromosomes.add(this.chromosomeHandler.cleanUpName(name));
            }
        }
    }

    public void setGraphFile(String graphFileName) {
        this.graphFileName = graphFileName;
    }

    public void setGenome(String genome) {
        if (genome != null) {
            this.genomeId = genome;
        }
    }

    protected static void updateIndexPositions(List<IndexEntry> blockIndex, LittleEndianOutputStream[] losArray, boolean doRestore, File outputFile, long currentPosition, long blockIndexPosition) throws IOException {
        long losPos = 0L;
        if (doRestore) {
            losPos = losArray[0].getWrittenCount();
            losArray[0].close();
        }
        try (RandomAccessFile raf = new RandomAccessFile(outputFile, "rw");){
            raf.getChannel().position(blockIndexPosition);
            BufferedByteWriter buffer = new BufferedByteWriter();
            for (IndexEntry aBlockIndex : blockIndex) {
                buffer.putInt(aBlockIndex.id);
                buffer.putLong(aBlockIndex.position + currentPosition);
                buffer.putInt(aBlockIndex.size);
            }
            raf.write(buffer.getBytes());
        }
        if (doRestore) {
            FileOutputStream fos = new FileOutputStream(outputFile, true);
            fos.getChannel().position(losPos);
            losArray[0] = new LittleEndianOutputStream(new BufferedOutputStream(fos, 0x200000));
            losArray[0].setWrittenCount(losPos);
        }
    }

    public void setFilter(ReadPairFilter.Type type) {
        if (type != null) {
            this.filter = new ReadPairFilter(type);
        }
    }

    public void setStatisticsFile(String statsOption) {
        this.statsFileName = statsOption;
    }

    private void initializeExpectedVectorCalculations() {
        this.expectedValueCalculations.clear();
        for (int bBinSize : this.bpBinSizes) {
            ExpectedValueCalculation calc = new ExpectedValueCalculation(this.chromosomeHandler, bBinSize, NormalizationHandler.NONE);
            String key = "BP_" + bBinSize;
            this.expectedValueCalculations.put(key, calc);
        }
    }

    public void setResolutionsWithInts(List<Integer> resolutions) {
        if (resolutions != null && resolutions.size() > 0) {
            Collections.sort(resolutions);
            Collections.reverse(resolutions);
            int[] bps = new int[resolutions.size()];
            for (int i = 0; i < bps.length; ++i) {
                bps[i] = resolutions.get(i);
            }
            this.bpBinSizes = bps;
            this.initializeExpectedVectorCalculations();
        }
    }

    public void setResolutions(List<String> resolutions) {
        if (resolutions != null && resolutions.size() > 0) {
            ArrayList<Integer> bpResolutions = new ArrayList<Integer>();
            for (String str : resolutions) {
                try {
                    int myInt = Integer.parseInt(str);
                    bpResolutions.add(myInt);
                }
                catch (NumberFormatException exception) {
                    System.err.println("Resolution improperly formatted. It must be in the form of a number, such as 1000000 for 1 million BP");
                    System.err.println("Fragment resolutions are deprecated and require using an older jar.");
                    System.exit(1);
                }
            }
            this.setResolutionsWithInts(bpResolutions);
        }
    }

    protected LittleEndianOutputStream[] initializeLosArrays(String headerFile, String footerFile) {
        try {
            this.losArray[0] = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(headerFile), 0x200000));
            if (footerFile.equalsIgnoreCase(headerFile)) {
                return this.losArray;
            }
            LittleEndianOutputStream[] losFooter = new LittleEndianOutputStream[]{new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(footerFile), 0x200000))};
            return losFooter;
        }
        catch (Exception e) {
            System.err.println("Unable to write to " + this.outputFile);
            System.exit(70);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected StringBuilder readFileIntoString(String fileName, String description) {
        if (fileName == null) return null;
        try (FileInputStream is = new FileInputStream(fileName);){
            String nextLine;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is), 0x200000);
            StringBuilder sb = new StringBuilder();
            while ((nextLine = reader.readLine()) != null) {
                sb.append(nextLine).append("\n");
            }
            StringBuilder stringBuilder = sb;
            return stringBuilder;
        }
        catch (IOException e) {
            System.err.println("Error while reading " + description + " file: " + e);
            return null;
        }
    }

    protected MatrixPP getInitialGenomeWideMatrixPP(ChromosomeHandler chromosomeHandler) {
        long genomeLength = chromosomeHandler.getChromosomeFromIndex(0).getLength();
        int binSize = (int)(genomeLength / 500L);
        if (binSize == 0) {
            binSize = 1;
        }
        int nBinsX = (int)(genomeLength / (long)binSize + 1L);
        int nBlockColumns = nBinsX / BLOCK_CAPACITY + 1;
        return new MatrixPP(0, 0, binSize, nBlockColumns, chromosomeHandler, this.countThreshold, this.v9DepthBase);
    }

    protected void writeHeader() throws IOException {
        System.out.println("Start preprocess");
        System.out.println("Writing header");
        byte[] magicBytes = "HIC".getBytes();
        LittleEndianOutputStream los = this.losArray[0];
        los.write(magicBytes[0]);
        los.write(magicBytes[1]);
        los.write(magicBytes[2]);
        los.write(0);
        los.writeInt(9);
        this.masterIndexPositionPosition = los.getWrittenCount();
        los.writeLong(0L);
        los.writeString(this.genomeId);
        this.normVectorIndexPosition = los.getWrittenCount();
        los.writeLong(0L);
        this.normVectorLengthPosition = los.getWrittenCount();
        los.writeLong(0L);
        StringBuilder stats = this.readFileIntoString(this.statsFileName, "stats");
        StringBuilder graphs = this.readFileIntoString(this.graphFileName, "graphs");
        StringBuilder hicFileScaling = new StringBuilder().append(this.hicFileScalingFactor);
        int nAttributes = 2;
        if (stats != null) {
            ++nAttributes;
        }
        if (graphs != null) {
            ++nAttributes;
        }
        if (this.v9DepthBase != 2) {
            ++nAttributes;
        }
        los.writeInt(nAttributes);
        los.writeString("software");
        los.writeString("Juicer Tools Version 3.30.00");
        if (stats != null) {
            los.writeString("statistics");
            los.writeString(stats.toString());
        }
        if (graphs != null) {
            los.writeString("graphs");
            los.writeString(graphs.toString());
        }
        los.writeString("hicFileScalingFactor");
        los.writeString(hicFileScaling.toString());
        if (this.v9DepthBase != 2) {
            los.writeString("v9-depth-base");
            los.writeString("" + this.v9DepthBase);
        }
        int nChrs = this.chromosomeHandler.size();
        los.writeInt(nChrs);
        for (Chromosome chromosome : this.chromosomeHandler.getChromosomeArray()) {
            los.writeString(chromosome.getName());
            los.writeLong(chromosome.getLength());
        }
        int nBpRes = this.bpBinSizes.length;
        los.writeInt(nBpRes);
        for (int bpBinSize : this.bpBinSizes) {
            los.writeInt(bpBinSize);
        }
        los.writeInt(0);
        this.numResolutions = nBpRes;
    }

    protected void writeFooter(LittleEndianOutputStream[] los) throws IOException {
        System.out.println();
        System.out.println("Writing footer");
        BigListOfByteWriters bufferList = new BigListOfByteWriters();
        bufferList.putInt(this.matrixPositions.size());
        for (Map.Entry<String, IndexEntry> entry : this.matrixPositions.entrySet()) {
            bufferList.expandBufferIfNeeded(1000);
            bufferList.putNullTerminatedString(entry.getKey());
            bufferList.putLong(entry.getValue().position);
            bufferList.putInt(entry.getValue().size);
        }
        bufferList.expandBufferIfNeeded(1000);
        bufferList.putInt(this.expectedValueCalculations.size());
        for (Map.Entry<String, Object> entry : this.expectedValueCalculations.entrySet()) {
            ExpectedValueCalculation ev = (ExpectedValueCalculation)entry.getValue();
            ev.computeDensity();
            int binSize = ev.getGridSize();
            HiCZoom.HiCUnit unit = HiCZoom.HiCUnit.BP;
            bufferList.putNullTerminatedString(unit.toString());
            bufferList.putInt(binSize);
            ListOfDoubleArrays expectedValues = ev.getDensityAvg();
            bufferList.putLong(expectedValues.getLength());
            for (double[] expectedArray : expectedValues.getValues()) {
                bufferList.expandBuffer();
                for (double value : expectedArray) {
                    bufferList.expandBufferIfNeeded(1000000);
                    bufferList.putFloat((float)value);
                }
            }
            Map<Integer, Double> normalizationFactors = ev.getChrScaleFactors();
            bufferList.expandBufferIfNeeded(1000000);
            bufferList.putInt(normalizationFactors.size());
            for (Map.Entry<Integer, Double> normFactor : normalizationFactors.entrySet()) {
                bufferList.putInt(normFactor.getKey());
                bufferList.putFloat(normFactor.getValue().floatValue());
            }
        }
        long nBytesV5 = bufferList.getBytesWritten();
        System.out.println("nBytesV5: " + nBytesV5);
        los[0].writeLong(nBytesV5);
        bufferList.writeToOutput(los[0]);
    }

    protected static Pair<Map<Long, List<IndexEntry>>, Long> writeMatrix(MatrixPP matrix, LittleEndianOutputStream[] losArray, Deflater compressor, Map<String, IndexEntry> matrixPositions, int chromosomePairIndex, boolean doMultiThreadedBehavior, File outputFile) throws IOException {
        LittleEndianOutputStream los = losArray[0];
        long position = los.getWrittenCount();
        los.writeInt(matrix.getChr1Idx());
        los.writeInt(matrix.getChr2Idx());
        int numResolutions = 0;
        for (MatrixZoomDataPP zd : matrix.getZoomData()) {
            if (zd == null) continue;
            ++numResolutions;
        }
        los.writeInt(numResolutions);
        for (int i = 0; i < matrix.getZoomData().length; ++i) {
            MatrixZoomDataPP zd = matrix.getZoomData()[i];
            if (zd == null) continue;
            WriterUtils.writeZoomHeader(zd, los);
        }
        long size = los.getWrittenCount() - position;
        if (chromosomePairIndex > -1) {
            matrixPositions.put("" + chromosomePairIndex, new IndexEntry(position, (int)size));
        } else {
            matrixPositions.put(matrix.getKey(), new IndexEntry(position, (int)size));
        }
        ConcurrentHashMap<Long, List<IndexEntry>> localBlockIndexes = new ConcurrentHashMap<Long, List<IndexEntry>>();
        for (int i = 0; i < matrix.getZoomData().length; ++i) {
            List<IndexEntry> blockIndex;
            MatrixZoomDataPP zd = matrix.getZoomData()[i];
            if (zd == null) continue;
            if (doMultiThreadedBehavior) {
                blockIndex = losArray.length > 1 ? zd.mergeAndWriteBlocksMT(losArray, i, matrix.getZoomData().length) : zd.mergeAndWriteBlocksST(losArray[0], compressor);
                localBlockIndexes.put(zd.blockIndexPosition, blockIndex);
                continue;
            }
            blockIndex = zd.mergeAndWriteBlocksST(losArray[0], compressor);
            HiCFileBuilder.updateIndexPositions(blockIndex, losArray, true, outputFile, 0L, zd.blockIndexPosition);
        }
        System.out.print(".");
        return new Pair<Map<Long, List<IndexEntry>>, Long>(localBlockIndexes, position);
    }

    protected void updateMasterIndex(String headerFile) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(headerFile, "rw");){
            raf.getChannel().position(this.masterIndexPositionPosition);
            BufferedByteWriter buffer = new BufferedByteWriter();
            buffer.putLong(this.masterIndexPosition);
            raf.write(buffer.getBytes());
            System.out.println("masterIndexPosition: " + this.masterIndexPosition);
        }
    }
}

