/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.original;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.datastructures.ListOfDoubleArrays;
import javastraw.reader.expected.ExpectedValueFunctionImpl;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationType;

public class ExpectedValueCalculation {
    private final int gridSize;
    private final int numberOfBins;
    private final Map<Integer, Double> chromosomeCounts = new ConcurrentHashMap<Integer, Double>();
    private final Map<Integer, Double> chrScaleFactors = new ConcurrentHashMap<Integer, Double>();
    private final NormalizationType type;
    private final double[] actualDistances;
    private ListOfDoubleArrays densityAvg;
    private final Map<Integer, Chromosome> chromosomesMap = new ConcurrentHashMap<Integer, Chromosome>();

    public ExpectedValueCalculation(ChromosomeHandler chromosomeHandler, int gridSize, NormalizationType type) {
        this.type = type;
        this.gridSize = gridSize;
        long maxLen = 0L;
        for (Chromosome chr : chromosomeHandler.getChromosomeArrayWithoutAllByAll()) {
            if (chr == null) continue;
            this.chromosomesMap.put(chr.getIndex(), chr);
            try {
                maxLen = Math.max(maxLen, chr.getLength());
            }
            catch (NullPointerException error) {
                System.err.println("Problem with creating fragment-delimited maps, NullPointerException.\nThis could be due to a null fragment map or to a mismatch in the chromosome name in the fragment map vis-a-vis the input file or chrom.sizes file.\nExiting.");
                System.exit(63);
            }
            catch (ArrayIndexOutOfBoundsException error) {
                System.err.println("Problem with creating fragment-delimited maps, ArrayIndexOutOfBoundsException.\nThis could be due to a null fragment map or to a mismatch in the chromosome name in the fragment map vis-a-vis the input file or chrom.sizes file.\nExiting.");
                System.exit(22);
            }
        }
        this.numberOfBins = (int)(maxLen / (long)gridSize) + 1;
        this.actualDistances = new double[this.numberOfBins];
        Arrays.fill(this.actualDistances, 0.0);
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public synchronized void addDistance(Integer chrIdx, int bin1, int bin2, double weight) {
        if (weight > 0.0) {
            int dist;
            Chromosome chr = this.chromosomesMap.get(chrIdx);
            if (chr == null) {
                return;
            }
            if (this.chromosomeCounts.containsKey(chrIdx)) {
                double count = this.chromosomeCounts.get(chrIdx);
                this.chromosomeCounts.put(chrIdx, count + weight);
            } else {
                this.chromosomeCounts.put(chrIdx, weight);
            }
            int n = dist = Math.abs(bin1 - bin2);
            this.actualDistances[n] = this.actualDistances[n] + weight;
        }
    }

    public void merge(ExpectedValueCalculation otherEVCalc) {
        for (Map.Entry<Integer, Chromosome> entry : otherEVCalc.chromosomesMap.entrySet()) {
            Chromosome chr = this.chromosomesMap.get(entry.getKey());
            if (chr == null || otherEVCalc.chromosomeCounts.get(entry.getKey()) == null) continue;
            Double count = this.chromosomeCounts.get(entry.getKey());
            if (count == null) {
                this.chromosomeCounts.put(entry.getKey(), otherEVCalc.chromosomeCounts.get(entry.getKey()));
                continue;
            }
            this.chromosomeCounts.put(entry.getKey(), count + otherEVCalc.chromosomeCounts.get(entry.getKey()));
        }
        for (int i = 0; i < this.actualDistances.length; ++i) {
            int n = i;
            this.actualDistances[n] = this.actualDistances[n] + otherEVCalc.actualDistances[i];
        }
    }

    public boolean hasData() {
        return !this.chromosomeCounts.isEmpty();
    }

    public synchronized void computeDensity() {
        long maxNumBins = 0L;
        double[] possibleDistances = new double[this.numberOfBins];
        for (Chromosome chr : this.chromosomesMap.values()) {
            if (chr == null || !this.chromosomeCounts.containsKey(chr.getIndex())) continue;
            long len = chr.getLength();
            long nChrBins = len / (long)this.gridSize;
            maxNumBins = Math.max(maxNumBins, nChrBins);
            int i = 0;
            while ((long)i < nChrBins) {
                int n = i;
                possibleDistances[n] = possibleDistances[n] + (double)(nChrBins - (long)i);
                ++i;
            }
        }
        this.densityAvg = new ListOfDoubleArrays(maxNumBins);
        double shotNoiseMinimum = 400.0;
        double numSum = this.actualDistances[0];
        double denSum = possibleDistances[0];
        int bound1 = 0;
        int bound2 = 0;
        for (long ii = 0L; ii < maxNumBins; ++ii) {
            if (numSum < shotNoiseMinimum) {
                while (numSum < shotNoiseMinimum && (long)bound2 < maxNumBins) {
                    numSum += this.actualDistances[++bound2];
                    denSum += possibleDistances[bound2];
                }
            } else if (numSum >= shotNoiseMinimum && bound2 - bound1 > 0) {
                while (bound2 - bound1 > 0 && bound2 < this.numberOfBins && bound1 < this.numberOfBins && numSum - this.actualDistances[bound1] - this.actualDistances[bound2] >= shotNoiseMinimum) {
                    numSum = numSum - this.actualDistances[bound1] - this.actualDistances[bound2];
                    denSum = denSum - possibleDistances[bound1] - possibleDistances[bound2];
                    ++bound1;
                    --bound2;
                }
            }
            this.densityAvg.set(ii, numSum / denSum);
            if ((long)(bound2 + 2) < maxNumBins) {
                numSum += this.actualDistances[bound2 + 1] + this.actualDistances[bound2 + 2];
                denSum += possibleDistances[bound2 + 1] + possibleDistances[bound2 + 2];
                bound2 += 2;
                continue;
            }
            if ((long)(bound2 + 1) >= maxNumBins) continue;
            numSum += this.actualDistances[bound2 + 1];
            denSum += possibleDistances[bound2 + 1];
            ++bound2;
        }
        for (Chromosome chr : this.chromosomesMap.values()) {
            if (chr == null || !this.chromosomeCounts.containsKey(chr.getIndex())) continue;
            long len = chr.getLength();
            long nChrBins = len / (long)this.gridSize;
            double expectedCount = 0.0;
            for (long n = 0L; n < nChrBins; ++n) {
                if (n >= maxNumBins) continue;
                double v = this.densityAvg.get(n);
                expectedCount += (double)(nChrBins - n) * v;
            }
            double observedCount = this.chromosomeCounts.get(chr.getIndex());
            double f = expectedCount / observedCount;
            this.chrScaleFactors.put(chr.getIndex(), f);
        }
    }

    public Map<Integer, Double> getChrScaleFactors() {
        return this.chrScaleFactors;
    }

    public ListOfDoubleArrays getDensityAvg() {
        return this.densityAvg;
    }

    public NormalizationType getType() {
        return this.type;
    }

    public ExpectedValueFunctionImpl getExpectedValueFunction() {
        this.computeDensity();
        return new ExpectedValueFunctionImpl(this.type, HiCZoom.HiCUnit.BP, this.gridSize, this.densityAvg, this.chrScaleFactors);
    }
}

