/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.original;

import hic.tools.utils.iterators.contacts.ChromosomeContactsIterator;
import hic.tools.utils.iterators.contacts.Contact;
import hic.tools.utils.original.ExpectedValueCalculation;
import hic.tools.utils.original.HiCFileBuilder;
import hic.tools.utils.original.MatrixPP;
import hic.tools.utils.original.PreprocessorFromDatasets;
import java.io.File;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.reader.Dataset;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.mzd.Matrix;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.HiCZoom;

public class DataReadingWorker
implements Runnable {
    private final AtomicInteger index;
    private final Chromosome chromosome1;
    private final Chromosome chromosome2;
    private final ChromosomeHandler chromosomeHandler;
    private final int[] bpBinSizes;
    private final int countThreshold;
    private final int v9DepthBase;
    private final int newBlockCapacity;
    private final int highestResolution;
    private final Dataset[] datasets;
    private final Map<String, ExpectedValueCalculation> expectedValueCalculations;
    private final File tmpDir;
    private final MatrixPP mergedMatrix;
    private final boolean onlyNearDiagonalContacts;

    public DataReadingWorker(AtomicInteger index, Chromosome chromosome1, Chromosome chromosome2, ChromosomeHandler chromosomeHandler, int[] bpBinSizes, int countThreshold, int v9DepthBase, int newBlockCapacity, Dataset[] datasets, int highestResolution, Map<String, ExpectedValueCalculation> expectedValueCalculations, File tmpDir, MatrixPP mergedMatrix, boolean onlyNearDiagonalContacts) {
        this.index = index;
        this.chromosome1 = chromosome1;
        this.chromosome2 = chromosome2;
        this.chromosomeHandler = chromosomeHandler;
        this.bpBinSizes = bpBinSizes;
        this.countThreshold = countThreshold;
        this.v9DepthBase = v9DepthBase;
        this.newBlockCapacity = newBlockCapacity;
        this.datasets = datasets;
        this.highestResolution = highestResolution;
        this.expectedValueCalculations = expectedValueCalculations;
        this.tmpDir = tmpDir;
        this.mergedMatrix = mergedMatrix;
        this.onlyNearDiagonalContacts = onlyNearDiagonalContacts;
    }

    private static void processMatrix(Dataset[] datasets, int i, Chromosome chromosome1, Chromosome chromosome2, int highestResolution, boolean onlyNearDiagonalContacts, MatrixPP matrixPP, Map<String, ExpectedValueCalculation> expectedValueCalculations, File tmpDir) {
        Matrix matrix = datasets[i].getMatrix(chromosome1, chromosome2, highestResolution);
        if (matrix == null) {
            System.err.println("Skipping null matrix " + chromosome1.getName() + " " + chromosome2.getName());
            return;
        }
        HiCZoom hZoom = new HiCZoom(highestResolution);
        MatrixZoomData zd = matrix.getZoomData(hZoom);
        if (zd == null) {
            System.err.println("Skipping null zd (res=" + highestResolution + ") " + chromosome1.getName() + " " + chromosome2.getName());
            return;
        }
        try {
            ChromosomeContactsIterator iter = new ChromosomeContactsIterator(zd, chromosome1, chromosome2, highestResolution);
            if (!iter.hasNext()) {
                System.err.println("No data in dataset " + i + " for region: " + zd.getKey());
            }
            while (iter.hasNext()) {
                Contact contact = iter.next();
                if (onlyNearDiagonalContacts && DataReadingWorker.tooFarFromDiagonal(contact)) continue;
                matrixPP.incrementCount(contact, expectedValueCalculations, tmpDir);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR " + e.getLocalizedMessage());
            System.err.println("Skipping dataset " + i + " for region: " + chromosome1.getName() + "_" + chromosome2.getName());
            e.printStackTrace();
            System.exit(90);
        }
        matrix.clearCacheForZoom(hZoom);
    }

    public static boolean tooFarFromDiagonal(Contact contact) {
        return HiCFileBuilder.tooFarFromDiagonal(contact.getPos1(), contact.getPos2());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int i = this.index.getAndIncrement();
        MatrixPP matrixPP = new MatrixPP(this.chromosome1.getIndex(), this.chromosome2.getIndex(), this.chromosomeHandler, this.bpBinSizes, this.countThreshold, this.v9DepthBase, this.newBlockCapacity);
        while (i < this.datasets.length) {
            DataReadingWorker.processMatrix(this.datasets, i, this.chromosome1, this.chromosome2, this.highestResolution, this.onlyNearDiagonalContacts, matrixPP, this.expectedValueCalculations, this.tmpDir);
            i = this.index.getAndIncrement();
        }
        Object object = PreprocessorFromDatasets.key;
        synchronized (object) {
            this.mergedMatrix.mergeMatrices(matrixPP);
        }
        matrixPP = null;
    }
}

