/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.original;

import hic.tools.utils.original.BlockPP;
import hic.tools.utils.original.BlockQueue;
import hic.tools.utils.original.RecordBlockUtils;
import htsjdk.tribble.util.LittleEndianInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class BlockQueueFB
implements BlockQueue {
    final File file;
    BlockPP block;
    long filePosition;
    final long fileLength;

    BlockQueueFB(File file) {
        this.file = file;
        this.fileLength = file.length();
        try {
            this.advance();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void advance() throws IOException {
        if (this.filePosition >= this.fileLength) {
            this.block = null;
            return;
        }
        try (FileInputStream fis = new FileInputStream(this.file);){
            fis.getChannel().position(this.filePosition);
            LittleEndianInputStream lis = new LittleEndianInputStream(fis);
            int blockNumber = lis.readInt();
            int nRecords = lis.readInt();
            byte[] bytes2 = new byte[nRecords * 12];
            this.readFully(bytes2, fis);
            this.block = new BlockPP(blockNumber, RecordBlockUtils.readContactRecordsToMap(nRecords, bytes2));
            this.filePosition = fis.getChannel().position();
        }
    }

    @Override
    public BlockPP getBlock() {
        return this.block;
    }

    void readFully(byte[] b, InputStream is) throws IOException {
        int count;
        int len = b.length;
        if (len < 1) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = is.read(b, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }
}

