/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.original;

import java.awt.Point;
import java.util.HashMap;
import java.util.Map;

class BlockPP {
    private final int number;
    private final Map<Point, Float> contactRecordMap;

    BlockPP(int number) {
        this.number = number;
        this.contactRecordMap = new HashMap<Point, Float>();
    }

    BlockPP(int number, Map<Point, Float> contactRecordMap) {
        this.number = number;
        this.contactRecordMap = contactRecordMap;
    }

    int getNumber() {
        return this.number;
    }

    int getNumRecords() {
        return this.contactRecordMap.size();
    }

    Map<Point, Float> getContactRecordMap() {
        return this.contactRecordMap;
    }

    void incrementCount(int x, int y, float score) {
        Point p = new Point(x, y);
        if (this.contactRecordMap.containsKey(p)) {
            this.contactRecordMap.put(p, Float.valueOf(score + this.contactRecordMap.get(p).floatValue()));
        } else {
            this.contactRecordMap.put(p, Float.valueOf(score));
        }
    }

    void merge(BlockPP other) {
        Map<Point, Float> oMap = other.getContactRecordMap();
        for (Point point : oMap.keySet()) {
            Float otherValue = oMap.get(point);
            if (this.contactRecordMap.containsKey(point)) {
                this.contactRecordMap.put(point, Float.valueOf(otherValue.floatValue() + this.contactRecordMap.get(point).floatValue()));
                continue;
            }
            this.contactRecordMap.put(point, otherValue);
        }
    }
}

