/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.norm.scale.cutoffs;

import hic.tools.utils.norm.scale.cutoffs.Cutoffs;
import java.util.ArrayList;
import javastraw.expected.Welford;
import javastraw.expected.Zscore;
import javastraw.reader.datastructures.ListOfIntArrays;

public class ZscoreCutoffs
extends Cutoffs {
    public ZscoreCutoffs(ListOfIntArrays array, float startingZscore, float deltaZscore, float maxZscore) {
        super(ZscoreCutoffs.createCutoffs(ZscoreCutoffs.getStats(array), startingZscore, deltaZscore, maxZscore));
    }

    private static Zscore getStats(ListOfIntArrays array) {
        Welford welford = new Welford();
        for (long p = 0L; p < array.getLength(); ++p) {
            int valP = array.get(p);
            if (valP <= 0) continue;
            welford.addValue(valP);
        }
        return welford.getZscore();
    }

    private static double[] createCutoffs(Zscore zscore, float minZ, float deltaZ, float maxZ) {
        ArrayList<Double> values2 = new ArrayList<Double>();
        values2.add(0.0);
        for (float cutoff = minZ; cutoff < maxZ; cutoff += deltaZ) {
            values2.add(zscore.getValForZscore(cutoff));
        }
        return ZscoreCutoffs.toArray(values2);
    }
}

