/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.norm.scale.cutoffs;

import hic.tools.utils.norm.scale.cutoffs.Cutoffs;
import java.util.ArrayList;
import javastraw.reader.datastructures.ListOfIntArrays;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class PercentileCutoffs
extends Cutoffs {
    public PercentileCutoffs(ListOfIntArrays array, float startingPercentile, float deltaPercentile, float maxPercentile) {
        super(PercentileCutoffs.createCutoffs(PercentileCutoffs.getStats(array), startingPercentile, deltaPercentile, maxPercentile));
    }

    private static DescriptiveStatistics getStats(ListOfIntArrays array) {
        DescriptiveStatistics statistics = new DescriptiveStatistics();
        for (long p = 0L; p < array.getLength(); ++p) {
            int valP = array.get(p);
            if (valP <= 0) continue;
            statistics.addValue(valP);
        }
        return statistics;
    }

    private static double[] createCutoffs(DescriptiveStatistics stats, float startingPercentile, float deltaPercentile, float maxPercentile) {
        ArrayList<Double> values2 = new ArrayList<Double>();
        values2.add(0.0);
        for (float cutoff = startingPercentile; cutoff < maxPercentile; cutoff += deltaPercentile) {
            values2.add(stats.getPercentile(cutoff));
        }
        return PercentileCutoffs.toArray(values2);
    }
}

