/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.norm.scale;

import hic.HiCGlobals;
import hic.tools.utils.norm.scale.VectorFunction;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.tools.ParallelizationTools;

public class ParallelVectorTools {
    public static void process(long matrixSize, VectorFunction function) {
        long[] cutoffs = ParallelVectorTools.getCutoffs(matrixSize);
        int numThreads = HiCGlobals.normThreads;
        AtomicInteger index = new AtomicInteger();
        ParallelizationTools.launchParallelizedCode(numThreads, () -> {
            int i = index.getAndIncrement();
            while (i < numThreads) {
                for (long p = cutoffs[i]; p < cutoffs[i + 1]; ++p) {
                    function.use(p);
                }
                i = index.getAndIncrement();
            }
        });
    }

    private static long[] getCutoffs(long matrixSize) {
        int n = HiCGlobals.normThreads;
        long[] bounds = new long[n + 1];
        for (int z = 0; z < n; ++z) {
            bounds[z] = matrixSize * (long)z / (long)n;
        }
        bounds[0] = 0L;
        bounds[n] = matrixSize;
        return bounds;
    }
}

