/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.norm;

import hic.HiCGlobals;
import hic.tools.utils.bigarray.BigContactList;
import hic.tools.utils.largelists.BigListOfByteWriters;
import hic.tools.utils.norm.FloatNormVector;
import hic.tools.utils.norm.GWNorms;
import hic.tools.utils.norm.IntraNorms;
import hic.tools.utils.norm.NormVectorUpdater;
import hic.tools.utils.norm.NormVectorsContainer;
import hic.tools.utils.norm.NormalizationTools;
import hic.tools.utils.norm.NormalizationVectorIndexEntry;
import hic.tools.utils.original.ExpectedValueCalculation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javastraw.reader.Dataset;
import javastraw.reader.DatasetReaderV2;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationHandler;
import javastraw.reader.type.NormalizationType;

public class NormalizationVectorUpdater
extends NormVectorUpdater {
    protected final Set<Chromosome> scaleBPFailChroms = new HashSet<Chromosome>();
    protected boolean weShouldBuildVC = true;
    protected boolean weShouldBuildVCSqrt = true;
    protected boolean weShouldBuildScale = true;

    protected void reEvaluateWhichIntraNormsToBuild(List<NormalizationType> normalizationsToBuild) {
        this.weShouldBuildVC = normalizationsToBuild.contains(NormalizationHandler.VC);
        this.weShouldBuildVCSqrt = normalizationsToBuild.contains(NormalizationHandler.VC_SQRT);
        this.weShouldBuildScale = normalizationsToBuild.contains(NormalizationHandler.SCALE);
    }

    public void updateHicFile(String path, List<NormalizationType> normalizationsToBuild, Map<NormalizationType, Integer> resolutionsToBuildTo, int resolutionCutoffToSaveRAM) throws IOException {
        this.reEvaluateWhichIntraNormsToBuild(normalizationsToBuild);
        Map<Integer, NormVectorsContainer> containers = this.getAllTheNormVectors(path, normalizationsToBuild, resolutionsToBuildTo, resolutionCutoffToSaveRAM);
        System.gc();
        this.calculateExpectedsAndWriteToFile(path, containers, resolutionCutoffToSaveRAM);
    }

    public Map<Integer, NormVectorsContainer> getAllTheNormVectors(String path, List<NormalizationType> normalizationsToBuild, Map<NormalizationType, Integer> resolutionsToBuildTo, int resolutionCutoffToSaveRAM) throws IOException {
        int minResolution = Integer.MAX_VALUE;
        for (Map.Entry<NormalizationType, Integer> entry : resolutionsToBuildTo.entrySet()) {
            if (entry.getValue() >= minResolution) continue;
            minResolution = entry.getValue();
        }
        HashMap<Integer, NormVectorsContainer> containers = new HashMap<Integer, NormVectorsContainer>();
        DatasetReaderV2 reader = new DatasetReaderV2(path, false, false);
        Dataset ds = reader.read();
        HiCGlobals.verifySupportedHiCFileWritingVersion(reader.getVersion());
        List<HiCZoom> resolutions = ds.getAllPossibleResolutions();
        boolean interDataAvailable = NormalizationTools.checkIfInterDataAvailable(resolutions.get(0), ds);
        if (!interDataAvailable) {
            System.out.println("Skipping GW_* and INTER_* normalizations because these regions have no data in this .hic file");
        }
        for (HiCZoom zoom : resolutions) {
            if (zoom.getBinSize() < minResolution) {
                System.out.println("Skipping zoom" + zoom);
                continue;
            }
            if (zoom.getUnit() == HiCZoom.HiCUnit.FRAG) continue;
            System.out.println();
            System.out.print("Calculating norms for zoom " + zoom);
            NormVectorsContainer container = new NormVectorsContainer(normalizationsToBuild, resolutionsToBuildTo, zoom);
            if (interDataAvailable) {
                GWNorms.getGWNormMaps(ds, zoom, resolutionCutoffToSaveRAM, container);
                ds.clearInterCacheForRes(zoom);
            }
            IntraNorms.getAllTheNorms(ds, zoom, resolutionCutoffToSaveRAM, container, this.weShouldBuildVC, this.weShouldBuildVCSqrt, this.weShouldBuildScale, resolutionsToBuildTo, this.scaleBPFailChroms);
            containers.put(zoom.getBinSize(), container);
        }
        ds.clearCache(false);
        ds = null;
        System.out.println("Balancing calculations completed");
        return containers;
    }

    public void calculateExpectedsAndWriteToFile(String path, Map<Integer, NormVectorsContainer> containers, int resolutionCutoffToSaveRAM) throws IOException {
        DatasetReaderV2 reader = new DatasetReaderV2(path, false, false);
        Dataset ds = reader.read();
        ds.clearCache(true);
        ChromosomeHandler chromosomeHandler = ds.getChromosomeHandler();
        List<HiCZoom> resolutions = ds.getAllPossibleResolutions();
        BigListOfByteWriters finalNormVectorBuffers = new BigListOfByteWriters();
        ArrayList<NormalizationVectorIndexEntry> finalNormVectorIndices = new ArrayList<NormalizationVectorIndexEntry>();
        ArrayList<ExpectedValueCalculation> finalExpectedValueCalculations = new ArrayList<ExpectedValueCalculation>();
        List<NormalizationType> sortedNorms = NormVectorsContainer.sortedNorms();
        for (HiCZoom zoom : resolutions) {
            NormVectorsContainer container;
            int resolution;
            if (zoom.getUnit() == HiCZoom.HiCUnit.FRAG || !containers.containsKey(resolution = zoom.getBinSize()) || (container = containers.get(resolution)) == null) continue;
            finalNormVectorBuffers.expandBuffer();
            HashMap<NormalizationType, ExpectedValueCalculation> expMap = new HashMap<NormalizationType, ExpectedValueCalculation>();
            for (NormalizationType norm : container.getNorms()) {
                expMap.put(norm, new ExpectedValueCalculation(chromosomeHandler, zoom.getBinSize(), norm));
            }
            for (Chromosome chrom : chromosomeHandler.getChromosomeArrayWithoutAllByAll()) {
                BigContactList ba = IntraNorms.getBigArrayFromAndClearCache(ds, chrom, zoom, resolutionCutoffToSaveRAM);
                if (ba == null) continue;
                for (NormalizationType norm : sortedNorms) {
                    Map<Chromosome, FloatNormVector> map;
                    if (!container.containsNorm(norm) || !(map = container.get(norm)).containsKey(chrom)) continue;
                    ListOfFloatArrays vector = map.get(chrom).getData();
                    NormVectorUpdater.updateNormVectorIndexWithVector(finalNormVectorIndices, finalNormVectorBuffers, vector, chrom.getIndex(), norm, zoom);
                    if (!expMap.containsKey(norm)) continue;
                    ba.updateGenomeWideExpected(chrom.getIndex(), vector, (ExpectedValueCalculation)expMap.get(norm));
                }
                ba.clear();
            }
            for (NormalizationType norm : sortedNorms) {
                if (!expMap.containsKey(norm) || !((ExpectedValueCalculation)expMap.get(norm)).hasData()) continue;
                finalExpectedValueCalculations.add((ExpectedValueCalculation)expMap.get(norm));
            }
            expMap.clear();
            container.clear();
            containers.remove(resolution);
        }
        ds.clearCache(false);
        NormalizationVectorUpdater.writeNormsToUpdateFile(reader, path, true, finalExpectedValueCalculations, null, finalNormVectorIndices, finalNormVectorBuffers, "Finished writing norms");
    }
}

