/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.norm;

import hic.HiCGlobals;
import hic.tools.utils.norm.FloatNormVector;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.reader.Dataset;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.mzd.Matrix;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationType;
import javastraw.tools.ParallelizationTools;

public class NormalizationTools {
    public static Map<Chromosome, FloatNormVector> parCreateNormVectorMap(ChromosomeHandler chromosomeHandler, int resolution, ListOfFloatArrays vector, NormalizationType norm, HiCZoom zoom) {
        LinkedHashMap<Chromosome, FloatNormVector> normVectorMap = new LinkedHashMap<Chromosome, FloatNormVector>();
        AtomicInteger index = new AtomicInteger(0);
        Chromosome[] chromosomes = chromosomeHandler.getChromosomeArrayWithoutAllByAll();
        long[] offsets = NormalizationTools.createOffsets(chromosomes, resolution);
        ParallelizationTools.launchParallelizedCode(HiCGlobals.normThreads, () -> {
            int i = index.getAndIncrement();
            while (i < chromosomes.length) {
                Chromosome c1 = chromosomes[i];
                long offset = offsets[i];
                long chrBinned = c1.getLength() / (long)resolution + 1L;
                ListOfFloatArrays chrNV = new ListOfFloatArrays(chrBinned);
                for (long k = 0L; k < chrNV.getLength(); ++k) {
                    chrNV.set(k, vector.get(offset + k));
                }
                Map map = normVectorMap;
                synchronized (map) {
                    normVectorMap.put(c1, new FloatNormVector(norm, c1.getIndex(), zoom, chrNV));
                }
                i = index.getAndIncrement();
            }
        });
        return normVectorMap;
    }

    private static long[] createOffsets(Chromosome[] chromosomes, int resolution) {
        long[] offsets = new long[chromosomes.length];
        offsets[0] = 0L;
        for (int i = 0; i < chromosomes.length - 1; ++i) {
            offsets[i + 1] = offsets[i] + chromosomes[i].getLength() / (long)resolution + 1L;
        }
        return offsets;
    }

    public static boolean checkIfInterDataAvailable(HiCZoom zoom, Dataset ds) {
        Chromosome[] chromosomes = ds.getChromosomeHandler().getChromosomeArrayWithoutAllByAll();
        for (int i = 0; i < chromosomes.length; ++i) {
            for (int j = i + 1; j < chromosomes.length; ++j) {
                try {
                    Matrix matrix = ds.getMatrix(chromosomes[i], chromosomes[j]);
                    if (matrix == null) {
                        return false;
                    }
                    MatrixZoomData zd = matrix.getZoomData(zoom);
                    if (zd != null) continue;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }
}

