/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.norm;

import hic.tools.clt.old.NormalizationBuilder;
import hic.tools.utils.bigarray.BigContactList;
import hic.tools.utils.largelists.BigFloatsArray;
import hic.tools.utils.norm.scale.FinalScale;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.type.NormalizationType;

public class NormalizationCalculations {
    private final long matrixSize;
    private final BigContactList ba;
    private final int resolution;

    public NormalizationCalculations(BigContactList ba, int resolution) {
        this.ba = ba;
        this.matrixSize = ba.getMatrixSize();
        this.resolution = resolution;
    }

    public ListOfFloatArrays getNormWithFix(NormalizationType normOption, String stem) {
        ListOfFloatArrays norm;
        if (NormalizationBuilder.usesVC(normOption)) {
            norm = this.computeVC();
        } else if (NormalizationBuilder.usesSCALE(normOption)) {
            norm = this.computeSCALE(this.computeVC(), stem);
        } else {
            if (NormalizationBuilder.isNONE(normOption)) {
                return new ListOfFloatArrays(this.matrixSize, 1.0f);
            }
            System.err.println("Not supported for normalization " + normOption);
            return null;
        }
        if (norm != null && norm.getLength() > 0L) {
            this.fixBySumFactor(norm);
        }
        return norm;
    }

    public void fixBySumFactor(ListOfFloatArrays norm) {
        double factor = this.getSumFactor(norm);
        norm.multiplyEverythingBy(factor);
    }

    public ListOfFloatArrays computeVC() {
        return this.ba.getRowSums();
    }

    public double getSumFactor(ListOfFloatArrays norm) {
        double[] normMatrixSums = this.getNormMatrixSumFactor(norm);
        return Math.sqrt(normMatrixSums[0] / normMatrixSums[1]);
    }

    public double[] getNormMatrixSumFactor(ListOfFloatArrays norm) {
        return this.ba.getNormMatrixSumFactor(norm);
    }

    private BigFloatsArray getInitialStartingVector(ListOfFloatArrays vc) {
        BigFloatsArray initial = new BigFloatsArray(vc.getLength());
        for (long i = 0L; i < vc.getLength(); ++i) {
            initial.set(i, (float)Math.sqrt(vc.get(i)));
        }
        return initial;
    }

    public ListOfFloatArrays computeSCALE(ListOfFloatArrays vc, String stem) {
        BigFloatsArray initial = this.getInitialStartingVector(vc);
        ListOfFloatArrays newNormVector = FinalScale.scaleToTargetVector(this.ba, this.matrixSize, initial, stem);
        if (newNormVector != null) {
            return this.ba.normalizeVectorByScaleFactor(newNormVector);
        }
        return null;
    }
}

