/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.norm;

import hic.tools.utils.norm.FloatNormVector;
import hic.tools.utils.norm.GWNorms;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationHandler;
import javastraw.reader.type.NormalizationType;

public class NormVectorsContainer {
    private final Map<NormalizationType, Map<Chromosome, FloatNormVector>> allData = new HashMap<NormalizationType, Map<Chromosome, FloatNormVector>>();
    private final List<NormalizationType> gwNormalizations;
    private final List<NormalizationType> gwInterNormalizations;

    public NormVectorsContainer(List<NormalizationType> normalizationsToBuild, Map<NormalizationType, Integer> resolutionsToBuildTo, HiCZoom zoom) {
        this.gwNormalizations = GWNorms.getGWNorms(normalizationsToBuild, resolutionsToBuildTo, zoom);
        this.gwInterNormalizations = GWNorms.getInterNorms(normalizationsToBuild, resolutionsToBuildTo, zoom);
    }

    public static List<NormalizationType> sortedNorms() {
        ArrayList<NormalizationType> norms0 = new ArrayList<NormalizationType>();
        norms0.add(NormalizationHandler.GW_SCALE);
        norms0.add(NormalizationHandler.GW_VC);
        norms0.sort(Comparator.comparing(NormalizationType::getLabel));
        ArrayList<NormalizationType> norms1 = new ArrayList<NormalizationType>();
        norms1.add(NormalizationHandler.INTER_SCALE);
        norms1.add(NormalizationHandler.INTER_VC);
        norms1.sort(Comparator.comparing(NormalizationType::getLabel));
        norms0.addAll(norms1);
        norms0.add(NormalizationHandler.VC);
        norms0.add(NormalizationHandler.VC_SQRT);
        norms0.add(NormalizationHandler.SCALE);
        return norms0;
    }

    public boolean hasNoGenomewideNorms() {
        return this.gwNormalizations.isEmpty() && this.gwInterNormalizations.isEmpty();
    }

    public boolean useGWIntra() {
        return !this.gwNormalizations.isEmpty();
    }

    public List<NormalizationType> getGenomewideNorms() {
        return this.gwNormalizations;
    }

    public List<NormalizationType> getGenomewideInterNorms() {
        return this.gwInterNormalizations;
    }

    public synchronized void put(NormalizationType normType, Map<Chromosome, FloatNormVector> wgVectors) {
        this.allData.put(normType, wgVectors);
    }

    public synchronized void add(Chromosome chrom, FloatNormVector vector) {
        NormalizationType norm = vector.getNormType();
        if (!this.allData.containsKey(norm)) {
            this.allData.put(norm, new HashMap());
        }
        this.allData.get(norm).put(chrom, vector);
    }

    public synchronized Map<Chromosome, FloatNormVector> get(NormalizationType norm) {
        return this.allData.get(norm);
    }

    public synchronized boolean containsNorm(NormalizationType norm) {
        return this.allData.containsKey(norm);
    }

    public synchronized void clear() {
        for (NormalizationType norm : this.allData.keySet()) {
            this.allData.get(norm).clear();
        }
        this.allData.clear();
    }

    public synchronized Set<NormalizationType> getNorms() {
        return this.allData.keySet();
    }
}

