/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.norm;

import hic.HiCGlobals;
import hic.tools.utils.largelists.BigListOfByteWriters;
import hic.tools.utils.norm.NormalizationVectorIndexEntry;
import hic.tools.utils.original.ExpectedValueCalculation;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javastraw.reader.DatasetReaderV2;
import javastraw.reader.datastructures.ListOfDoubleArrays;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.expected.ExpectedValueFunction;
import javastraw.reader.expected.ExpectedValueFunctionImpl;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationType;
import org.broad.igv.tdf.BufferedByteWriter;

public class NormVectorUpdater {
    static void updateNormVectorIndexWithVector(List<NormalizationVectorIndexEntry> normVectorIndex, BigListOfByteWriters bufferList, ListOfFloatArrays vec, int chrIdx, NormalizationType type, HiCZoom zoom) throws IOException {
        long position = bufferList.getBytesWritten();
        NormVectorUpdater.putFloatArraysIntoBufferList(bufferList, vec.getValues());
        long newPos = bufferList.getBytesWritten();
        int sizeInBytes = (int)(newPos - position);
        normVectorIndex.add(new NormalizationVectorIndexEntry(type.toString(), chrIdx, zoom.getUnit().toString(), zoom.getBinSize(), position, sizeInBytes));
    }

    static void putFloatArraysIntoBufferList(BigListOfByteWriters bufferList, List<float[]> arrays) throws IOException {
        bufferList.expandBufferIfNeeded(8);
        long vectorLength = 0L;
        for (float[] array : arrays) {
            vectorLength += (long)array.length;
        }
        bufferList.putLong(vectorLength);
        for (float[] array : arrays) {
            bufferList.expandBufferIfNeeded(4 * array.length);
            for (float val : array) {
                bufferList.putFloat(val);
            }
        }
    }

    private static void putMapValuesIntoBuffer(BigListOfByteWriters bufferList, Map<Integer, Double> hashmap) throws IOException {
        int bytesNeeded = 4 + 8 * hashmap.size();
        bufferList.expandBufferIfNeeded(bytesNeeded);
        bufferList.putInt(hashmap.size());
        ArrayList<Integer> keys2 = new ArrayList<Integer>(hashmap.keySet());
        Collections.sort(keys2);
        for (Integer key : keys2) {
            bufferList.putInt(key);
            bufferList.putFloat(hashmap.get(key).floatValue());
        }
    }

    private static void writeExpectedToBuffer(RandomAccessFile raf, BigListOfByteWriters bufferList, long filePosition) throws IOException {
        raf.getChannel().position(filePosition);
        bufferList.writeToRAF(raf);
    }

    static void writeNormIndex(BufferedByteWriter buffer, List<NormalizationVectorIndexEntry> normVectorIndex) throws IOException {
        buffer.putInt(normVectorIndex.size());
        for (NormalizationVectorIndexEntry entry : normVectorIndex) {
            buffer.putNullTerminatedString(entry.type);
            buffer.putInt(entry.chrIdx);
            buffer.putNullTerminatedString(entry.unit);
            buffer.putInt(entry.resolution);
            buffer.putLong(entry.position);
            buffer.putLong(entry.sizeInBytes);
        }
    }

    static void writeNormsToUpdateFile(DatasetReaderV2 reader, String path, boolean useCalcNotFunc, List<ExpectedValueCalculation> expectedValueCalculations, Map<String, ExpectedValueFunction> expectedValueFunctionMap, List<NormalizationVectorIndexEntry> normVectorIndices, BigListOfByteWriters normVectorBuffers, String message) throws IOException {
        HiCGlobals.verifySupportedHiCFileWritingVersion(reader.getVersion());
        long filePosition = reader.getNormFilePosition();
        long nviHeaderPosition = reader.getNviHeaderPosition();
        try (RandomAccessFile raf = new RandomAccessFile(path, "rw");){
            BigListOfByteWriters bufferList = new BigListOfByteWriters();
            if (useCalcNotFunc) {
                NormVectorUpdater.writeExpectedValues(bufferList, expectedValueCalculations);
            } else {
                NormVectorUpdater.writeExpectedValues(bufferList, expectedValueFunctionMap);
            }
            NormVectorUpdater.writeExpectedToBuffer(raf, bufferList, filePosition);
            NormVectorUpdater.writeNormsToBuffer(raf, normVectorIndices, normVectorBuffers, nviHeaderPosition);
        }
        System.out.println(message);
    }

    private static void writeExpectedValues(BigListOfByteWriters bufferList, List<ExpectedValueCalculation> expectedValueCalculations) throws IOException {
        bufferList.expandBufferIfNeeded(4);
        bufferList.putInt(expectedValueCalculations.size());
        for (ExpectedValueCalculation ev : expectedValueCalculations) {
            ev.computeDensity();
            HiCZoom.HiCUnit unit = HiCZoom.HiCUnit.BP;
            NormVectorUpdater.appendExpectedValuesToBuffer(bufferList, ev.getType(), unit, ev.getGridSize(), ev.getDensityAvg(), ev.getChrScaleFactors());
        }
    }

    private static void writeExpectedValues(BigListOfByteWriters bufferList, Map<String, ExpectedValueFunction> expectedValueFunctionMap) throws IOException {
        bufferList.expandBufferIfNeeded(4);
        bufferList.putInt(expectedValueFunctionMap.size());
        for (ExpectedValueFunction function : expectedValueFunctionMap.values()) {
            NormVectorUpdater.appendExpectedValuesToBuffer(bufferList, function.getNormalizationType(), function.getUnit(), function.getBinSize(), function.getExpectedValuesNoNormalization(), ((ExpectedValueFunctionImpl)function).getNormFactors());
        }
    }

    private static void appendExpectedValuesToBuffer(BigListOfByteWriters bufferList, NormalizationType normalizationType, HiCZoom.HiCUnit unit, int binSize, ListOfDoubleArrays expectedValuesNoNormalization, Map<Integer, Double> normFactors) throws IOException {
        int bytesNeeded = normalizationType.toString().length() + 1;
        bytesNeeded += unit.toString().length() + 1;
        bufferList.expandBufferIfNeeded(bytesNeeded += 4);
        bufferList.putNullTerminatedString(normalizationType.toString());
        bufferList.putNullTerminatedString(unit.toString());
        bufferList.putInt(binSize);
        NormVectorUpdater.putFloatArraysIntoBufferList(bufferList, expectedValuesNoNormalization.convertToFloats().getValues());
        NormVectorUpdater.putMapValuesIntoBuffer(bufferList, normFactors);
    }

    private static void writeNormsToBuffer(RandomAccessFile raf, List<NormalizationVectorIndexEntry> normVectorIndex, BigListOfByteWriters normVectorBuffers, long nviHeaderPosition) throws IOException {
        BufferedByteWriter buffer = new BufferedByteWriter();
        NormVectorUpdater.writeNormIndex(buffer, normVectorIndex);
        long normVectorStartPosition = raf.getChannel().position() + (long)buffer.bytesWritten();
        long size = buffer.bytesWritten();
        long NVI = normVectorStartPosition - size;
        raf.getChannel().position(nviHeaderPosition);
        BufferedByteWriter headerBuffer = new BufferedByteWriter();
        headerBuffer.putLong(NVI);
        headerBuffer.putLong(size);
        raf.write(headerBuffer.getBytes());
        raf.getChannel().position(NVI);
        for (NormalizationVectorIndexEntry entry : normVectorIndex) {
            entry.position += normVectorStartPosition;
        }
        buffer = new BufferedByteWriter();
        NormVectorUpdater.writeNormIndex(buffer, normVectorIndex);
        raf.write(buffer.getBytes());
        normVectorBuffers.writeToRAF(raf);
    }
}

