/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.norm;

import hic.HiCGlobals;
import hic.tools.utils.bigarray.BigContactArrayCreator;
import hic.tools.utils.bigarray.BigContactList;
import hic.tools.utils.norm.FloatNormVector;
import hic.tools.utils.norm.NormVectorsContainer;
import hic.tools.utils.norm.NormalizationCalculations;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.reader.Dataset;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.mzd.Matrix;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationHandler;
import javastraw.reader.type.NormalizationType;
import javastraw.tools.ParallelizationTools;

public class IntraNorms {
    public static void getAllTheNorms(Dataset ds, HiCZoom zoom, int resolutionCutoffToSaveRAM, NormVectorsContainer container, boolean weShouldBuildVC, boolean weShouldBuildVCSqrt, boolean weShouldBuildScale, Map<NormalizationType, Integer> resolutionsToBuildTo, Set<Chromosome> scaleBPFailChroms) {
        Chromosome[] chromosomes = ds.getChromosomeHandler().getChromosomeArrayWithoutAllByAll();
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(HiCGlobals.chromThreads, () -> {
            int sIndx = index.getAndIncrement();
            while (sIndx < chromosomes.length) {
                Chromosome chrom = chromosomes[sIndx];
                BigContactList ba = IntraNorms.getBigArrayFromAndClearCache(ds, chrom, zoom, resolutionCutoffToSaveRAM);
                if (ba != null) {
                    NormalizationCalculations nc = new NormalizationCalculations(ba, zoom.getBinSize());
                    if (weShouldBuildVC || weShouldBuildVCSqrt || weShouldBuildScale) {
                        boolean saveScale;
                        boolean saveVC = weShouldBuildVC && zoom.getBinSize() >= (Integer)resolutionsToBuildTo.get(NormalizationHandler.VC);
                        boolean saveVCSqrt = weShouldBuildVCSqrt && zoom.getBinSize() >= (Integer)resolutionsToBuildTo.get(NormalizationHandler.VC_SQRT);
                        boolean bl = saveScale = weShouldBuildScale && zoom.getBinSize() >= (Integer)resolutionsToBuildTo.get(NormalizationHandler.SCALE);
                        if (saveVC || saveVCSqrt || saveScale) {
                            IntraNorms.buildTheNorms(saveVC, saveVCSqrt, saveScale, chrom, nc, zoom, scaleBPFailChroms, container);
                        }
                    }
                    nc = null;
                    ba.clear();
                }
                sIndx = index.getAndIncrement();
            }
        });
    }

    public static BigContactList getBigArrayFromAndClearCache(Dataset ds, Chromosome chrom, HiCZoom zoom, int resolutionCutoffToSaveRAM) {
        Matrix matrix = ds.getMatrix(chrom, chrom);
        if (matrix == null) {
            return null;
        }
        MatrixZoomData zd = matrix.getZoomData(zoom);
        if (zd == null) {
            return null;
        }
        if (HiCGlobals.printVerboseComments) {
            System.out.println("Now Doing " + chrom.getName());
        }
        BigContactList ba = zoom.getBinSize() < resolutionCutoffToSaveRAM ? BigContactArrayCreator.createLocalVersionFromZD(zd) : BigContactArrayCreator.createFromZD(zd);
        matrix.clearCacheForZoom(zoom);
        return ba;
    }

    private static void buildTheNorms(boolean saveVC, boolean saveVCSqrt, boolean saveScale, Chromosome chrom, NormalizationCalculations nc, HiCZoom zoom, Set<Chromosome> scaleBPFailChroms, NormVectorsContainer container) {
        int chrIdx = chrom.getIndex();
        ListOfFloatArrays vc = nc.computeVC();
        String stem = "NORM_" + chrIdx + "_" + zoom.getBinSize();
        if (saveScale && !scaleBPFailChroms.contains(chrom)) {
            ListOfFloatArrays scale = nc.computeSCALE(vc, stem);
            if (scale == null) {
                scaleBPFailChroms.add(chrom);
            } else {
                nc.fixBySumFactor(scale);
                container.add(chrom, new FloatNormVector(NormalizationHandler.SCALE, chrom.getIndex(), zoom, scale));
            }
        }
        if (saveVCSqrt) {
            ListOfFloatArrays vcSqrt = new ListOfFloatArrays(vc.getLength());
            int i = 0;
            while ((long)i < vc.getLength()) {
                vcSqrt.set(i, (float)Math.sqrt(vc.get(i)));
                ++i;
            }
            nc.fixBySumFactor(vcSqrt);
            container.add(chrom, new FloatNormVector(NormalizationHandler.VC_SQRT, chrom.getIndex(), zoom, vcSqrt));
        }
        if (saveVC) {
            nc.fixBySumFactor(vc);
            container.add(chrom, new FloatNormVector(NormalizationHandler.VC, chrom.getIndex(), zoom, vc));
        }
    }
}

