/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.norm;

import hic.tools.utils.bigarray.BigContactList;
import hic.tools.utils.bigarray.BigGWContactArrayCreator;
import hic.tools.utils.norm.FloatNormVector;
import hic.tools.utils.norm.NormVectorsContainer;
import hic.tools.utils.norm.NormalizationCalculations;
import hic.tools.utils.norm.NormalizationTools;
import hic.tools.utils.original.ExpectedValueCalculation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javastraw.reader.Dataset;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationHandler;
import javastraw.reader.type.NormalizationType;

public class GWNorms {
    public static List<NormalizationType> getGWNorms(List<NormalizationType> allNorms, Map<NormalizationType, Integer> resolutionsToBuildTo, HiCZoom zoom) {
        ArrayList<NormalizationType> norms = new ArrayList<NormalizationType>();
        for (NormalizationType norm : allNorms) {
            if (!NormalizationHandler.isGenomeWideNorm(norm) || !NormalizationHandler.isGenomeWideNormIntra(norm) || zoom.getBinSize() < resolutionsToBuildTo.get(norm)) continue;
            norms.add(norm);
        }
        norms.sort(Comparator.comparing(NormalizationType::getLabel));
        return norms;
    }

    public static List<NormalizationType> getInterNorms(List<NormalizationType> allNorms, Map<NormalizationType, Integer> resolutionsToBuildTo, HiCZoom zoom) {
        ArrayList<NormalizationType> norms = new ArrayList<NormalizationType>();
        for (NormalizationType norm : allNorms) {
            if (!NormalizationHandler.isGenomeWideNorm(norm) || NormalizationHandler.isGenomeWideNormIntra(norm) || zoom.getBinSize() < resolutionsToBuildTo.get(norm)) continue;
            norms.add(norm);
        }
        norms.sort(Comparator.comparing(NormalizationType::getLabel));
        return norms;
    }

    public static void getGWNormMaps(Dataset ds, HiCZoom zoom, int resCutoffForRAM, NormVectorsContainer container) {
        Map<Chromosome, FloatNormVector> wgVectors;
        if (container.hasNoGenomewideNorms()) {
            return;
        }
        ChromosomeHandler handler = ds.getChromosomeHandler();
        BigContactList ba = zoom.getBinSize() < 25 * resCutoffForRAM ? BigGWContactArrayCreator.createLocalVersionWholeGenome(ds, handler, zoom, container.useGWIntra()) : BigGWContactArrayCreator.createForWholeGenome(ds, handler, zoom, container.useGWIntra());
        for (NormalizationType normType : container.getGenomewideNorms()) {
            wgVectors = GWNorms.getWGVectors(zoom, normType, ba, handler, "GW");
            if (wgVectors == null) continue;
            container.put(normType, wgVectors);
        }
        ba.clearIntraAndShiftInter();
        for (NormalizationType normType : container.getGenomewideInterNorms()) {
            wgVectors = GWNorms.getWGVectors(zoom, normType, ba, handler, "INTER");
            if (wgVectors == null) continue;
            container.put(normType, wgVectors);
        }
        ba.clear();
    }

    private static Map<Chromosome, FloatNormVector> getWGVectors(HiCZoom zoom, NormalizationType norm, BigContactList ba, ChromosomeHandler handler, String stem) {
        int resolution = zoom.getBinSize();
        NormalizationCalculations calculations = new NormalizationCalculations(ba, resolution);
        ListOfFloatArrays vector = calculations.getNormWithFix(norm, stem + "_NORM_" + zoom.getBinSize());
        if (vector == null) {
            return null;
        }
        return NormalizationTools.parCreateNormVectorMap(handler, resolution, vector, norm, zoom);
    }

    public static void populateGWExpecteds(List<ExpectedValueCalculation> expectedValueCalculations, Map<NormalizationType, ExpectedValueCalculation> expectedMap, List<NormalizationType> norms) {
        for (NormalizationType norm : norms) {
            ExpectedValueCalculation expected;
            if (!expectedMap.containsKey(norm) || !(expected = expectedMap.get(norm)).hasData()) continue;
            expectedValueCalculations.add(expected);
        }
    }
}

