/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.norm;

import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationType;

public class FloatNormVector {
    private final NormalizationType type;
    private final int chrIdx;
    private final HiCZoom.HiCUnit unit;
    private final int resolution;
    private final ListOfFloatArrays data;

    public FloatNormVector(NormalizationType type, int chrIdx, HiCZoom zoom, ListOfFloatArrays data) {
        this.type = type;
        this.chrIdx = chrIdx;
        this.unit = zoom.getUnit();
        this.resolution = zoom.getBinSize();
        this.data = data;
    }

    public static String getKey(NormalizationType type, int chrIdx, String unit, int resolution) {
        return type + "_" + chrIdx + "_" + unit + "_" + resolution;
    }

    public int getChrIdx() {
        return this.chrIdx;
    }

    public int getResolution() {
        return this.resolution;
    }

    public String getKey() {
        return FloatNormVector.getKey(this.type, this.chrIdx, this.unit.toString(), this.resolution);
    }

    public ListOfFloatArrays getData() {
        return this.data;
    }

    public NormalizationType getNormType() {
        return this.type;
    }
}

