/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.norm;

import hic.HiCGlobals;
import hic.tools.utils.largelists.BigListOfByteWriters;
import hic.tools.utils.norm.NormVectorInfo;
import hic.tools.utils.norm.NormVectorUpdater;
import hic.tools.utils.norm.NormalizationVectorIndexEntry;
import hic.tools.utils.original.ExpectedValueCalculation;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javastraw.reader.Dataset;
import javastraw.reader.DatasetReaderV2;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.datastructures.ListOfDoubleArrays;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.reader.expected.ExpectedValueFunction;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.norm.NormalizationVector;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationHandler;
import javastraw.reader.type.NormalizationType;
import javastraw.tools.HiCFileTools;

public class CustomNormVectorFileHandler
extends NormVectorUpdater {
    public static void updateHicFile(String path, String vectorPath) throws IOException {
        DatasetReaderV2 reader = new DatasetReaderV2(path, false, false);
        Dataset ds = reader.read();
        HiCGlobals.verifySupportedHiCFileVersion(reader.getVersion());
        String[] vectorPaths = vectorPath.split(",");
        NormVectorInfo normVectorInfo = CustomNormVectorFileHandler.completeCalculationsNecessaryForUpdatingCustomNormalizations(ds, vectorPaths, true);
        CustomNormVectorFileHandler.writeNormsToUpdateFile(reader, path, false, null, normVectorInfo.getExpectedValueFunctionMap(), normVectorInfo.getNormVectorIndices(), normVectorInfo.getNormVectorBuffers(), "Finished adding another normalization.");
        System.out.println("all custom norms added");
    }

    private static NormVectorInfo completeCalculationsNecessaryForUpdatingCustomNormalizations(Dataset ds, String[] filePaths, boolean overwriteHicFileFooter) throws IOException {
        Map<NormalizationType, Map<String, NormalizationVector>> normalizationVectorMap = CustomNormVectorFileHandler.readVectorFile(filePaths, ds.getChromosomeHandler(), ds.getNormalizationHandler());
        ChromosomeHandler chromosomeHandler = ds.getChromosomeHandler();
        Map<String, Integer> fragCountMap = ds.getFragmentCounts();
        List<HiCZoom> resolutions = ds.getAllPossibleResolutions();
        BigListOfByteWriters normVectorBuffers = new BigListOfByteWriters();
        ArrayList<NormalizationVectorIndexEntry> normVectorIndices = new ArrayList<NormalizationVectorIndexEntry>();
        Map<String, ExpectedValueFunction> expectedValueFunctionMap = ds.getExpectedValueFunctionMap();
        expectedValueFunctionMap.entrySet().removeIf(entry -> ((String)entry.getKey()).contains("NONE"));
        if (overwriteHicFileFooter) {
            for (HiCZoom zoom : resolutions) {
                for (NormalizationType type : NormalizationHandler.getAllNormTypes()) {
                    for (Chromosome chr : chromosomeHandler.getChromosomeArrayWithoutAllByAll()) {
                        NormalizationVector existingNorm = ds.getNormalizationVector(chr.getIndex(), zoom, type);
                        if (existingNorm == null) continue;
                        long position = normVectorBuffers.getBytesWritten();
                        CustomNormVectorFileHandler.putFloatArraysIntoBufferList(normVectorBuffers, existingNorm.getData().convertToFloats().getValues());
                        long newPos = normVectorBuffers.getBytesWritten();
                        int sizeInBytes = (int)(newPos - position);
                        normVectorIndices.add(new NormalizationVectorIndexEntry(type.toString(), chr.getIndex(), zoom.getUnit().toString(), zoom.getBinSize(), position, sizeInBytes));
                    }
                }
            }
        }
        for (NormalizationType customNormType : normalizationVectorMap.keySet()) {
            Map<String, NormalizationVector> normVectorsByChrAndZoom = normalizationVectorMap.get(customNormType);
            HashSet<String> keySet = new HashSet<String>(normVectorsByChrAndZoom.keySet());
            HashMap chrAndResolutionWhichFailed = new HashMap();
            for (String key : keySet) {
                NormalizationVector nv = normVectorsByChrAndZoom.get(key);
                if (!chrAndResolutionWhichFailed.containsKey(nv.getChrIdx()) || nv.getResolution() >= (Integer)chrAndResolutionWhichFailed.get(nv.getChrIdx())) continue;
                normVectorsByChrAndZoom.remove(key);
            }
        }
        for (HiCZoom zoom : resolutions) {
            for (NormalizationType customNormType : normalizationVectorMap.keySet()) {
                ExpectedValueCalculation evLoaded = new ExpectedValueCalculation(chromosomeHandler, zoom.getBinSize(), customNormType);
                String key = ExpectedValueFunction.getKey(zoom, customNormType, false, 0);
                for (Chromosome chr : chromosomeHandler.getChromosomeArrayWithoutAllByAll()) {
                    MatrixZoomData zd = HiCFileTools.getMatrixZoomData(ds, chr, chr, zoom);
                    if (zd == null) continue;
                    CustomNormVectorFileHandler.handleLoadedVector(customNormType, chr.getIndex(), zoom, normalizationVectorMap.get(customNormType), normVectorBuffers, normVectorIndices, zd, evLoaded);
                }
                expectedValueFunctionMap.put(key, evLoaded.getExpectedValueFunction());
            }
        }
        ds.setExpectedValueFunctionMap(expectedValueFunctionMap);
        return new NormVectorInfo(normalizationVectorMap, normVectorBuffers, normVectorIndices, expectedValueFunctionMap);
    }

    private static void handleLoadedVector(NormalizationType customNormType, int chrIndx, HiCZoom zoom, Map<String, NormalizationVector> normVectors, BigListOfByteWriters normVectorBuffers, List<NormalizationVectorIndexEntry> normVectorIndex, MatrixZoomData zd, ExpectedValueCalculation evLoaded) throws IOException {
        String key = NormalizationVector.getKey(customNormType, chrIndx, zoom.getUnit().toString(), zoom.getBinSize());
        if (normVectors.containsKey(key)) {
            NormalizationVector vector = normVectors.get(key);
            if (vector == null || vector.getData() == null) {
                return;
            }
            long position = normVectorBuffers.getBytesWritten();
            CustomNormVectorFileHandler.putFloatArraysIntoBufferList(normVectorBuffers, vector.getData().convertToFloats().getValues());
            long newPos = normVectorBuffers.getBytesWritten();
            int sizeInBytes = (int)(newPos - position);
            normVectorIndex.add(new NormalizationVectorIndexEntry(customNormType.toString(), chrIndx, zoom.getUnit().toString(), zoom.getBinSize(), position, sizeInBytes));
            CustomNormVectorFileHandler.addDistancesFromIterator(chrIndx, zd.getDirectIterator(), vector.getData().convertToFloats(), evLoaded);
        }
    }

    private static void addDistancesFromIterator(int chrIndx, Iterator<ContactRecord> iterator2, ListOfFloatArrays vector, ExpectedValueCalculation ev) {
        while (iterator2.hasNext()) {
            float yVal;
            ContactRecord cr = iterator2.next();
            int x = cr.getBinX();
            int y = cr.getBinY();
            float counts = cr.getCounts();
            float xVal = vector.get(x);
            if (!(xVal > 0.0f & (yVal = vector.get(y)) > 0.0f)) continue;
            double value = counts / (xVal * yVal);
            ev.addDistance(chrIndx, x, y, value);
        }
    }

    private static Map<NormalizationType, Map<String, NormalizationVector>> readVectorFile(String[] fnames, ChromosomeHandler chromosomeHandler, NormalizationHandler normalizationHandler) throws IOException {
        HashMap<NormalizationType, Map<String, NormalizationVector>> normVectors = new HashMap<NormalizationType, Map<String, NormalizationVector>>();
        for (String fname : fnames) {
            BufferedReader vectorReader;
            if (fname.endsWith(".gz")) {
                FileInputStream fileStream = new FileInputStream(fname);
                GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
                InputStreamReader decoder = new InputStreamReader((InputStream)gzipStream, StandardCharsets.UTF_8);
                vectorReader = new BufferedReader(decoder, 0x400000);
            } else {
                vectorReader = new BufferedReader(new InputStreamReader(new FileInputStream(fname)), 0x200000);
            }
            Chromosome chr = null;
            int resolution = -1;
            HiCZoom.HiCUnit unit = null;
            NormalizationType customNormType = null;
            boolean needsToBeScaledTo = false;
            String nextLine = vectorReader.readLine();
            while (nextLine != null) {
                if (nextLine.startsWith("vector")) {
                    String[] tokens2 = nextLine.split("\\s+");
                    chr = chromosomeHandler.getChromosomeFromName(tokens2[2]);
                    if (chr == null) {
                        System.err.println("Skipping " + tokens2[2] + " which isn't in dataset");
                        nextLine = CustomNormVectorFileHandler.skipLinesUntilTextEncountered(vectorReader, "vector");
                        continue;
                    }
                    customNormType = normalizationHandler.getNormTypeFromString(tokens2[1]);
                    resolution = Integer.parseInt(tokens2[3]);
                    unit = HiCZoom.HiCUnit.valueOf(tokens2[4]);
                    needsToBeScaledTo = tokens2[0].toLowerCase().contains("scale");
                }
                if (chr != null && customNormType != null) {
                    if (HiCGlobals.printVerboseComments) {
                        System.out.println("Adding norm " + customNormType + " for chr " + chr.getName() + " at " + resolution + " " + unit + " resolution.");
                    }
                    long size = chr.getLength() / (long)resolution + 1L;
                    ListOfDoubleArrays data = new ListOfDoubleArrays(size);
                    int i = 0;
                    nextLine = vectorReader.readLine();
                    while (nextLine != null && !nextLine.startsWith("vector")) {
                        if (nextLine.equalsIgnoreCase("nan") || nextLine.equals(".")) {
                            data.set(i, Double.NaN);
                        } else {
                            data.set(i, Double.parseDouble(nextLine));
                        }
                        if ((long)(++i) > size) {
                            throw new IOException("More values than resolution would indicate");
                        }
                        nextLine = vectorReader.readLine();
                    }
                    if (!normVectors.containsKey(customNormType)) {
                        normVectors.put(customNormType, new HashMap());
                    }
                    NormalizationVector vector = new NormalizationVector(customNormType, chr.getIndex(), unit, resolution, data);
                    ((Map)normVectors.get(customNormType)).put(vector.getKey(), vector);
                    continue;
                }
                System.err.println("Chromosome vector null");
            }
        }
        return normVectors;
    }

    private static String skipLinesUntilTextEncountered(BufferedReader vectorReader, String string) throws IOException {
        String nextLine = vectorReader.readLine();
        while (nextLine != null && !nextLine.startsWith(string)) {
            nextLine = vectorReader.readLine();
        }
        return nextLine;
    }
}

