/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.merge.merger;

import hic.tools.utils.merge.merger.StatsMerger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class SingleAlignmentStatsMerger
extends StatsMerger {
    @Override
    public void printToMergedFile(String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            out.write("Read type: Single End\n");
            this.write(out, "Sequenced Reads: ", StatsMerger.STATS_LABEL.TOTAL_SEQ, -1L, -1L);
            long denom1 = this.getStatistic(StatsMerger.STATS_LABEL.TOTAL_SEQ);
            this.write(out, "No chimera found: ", StatsMerger.STATS_LABEL.NO_CHIMERA, denom1, -1L);
            this.write(out, "0 alignments: ", StatsMerger.STATS_LABEL.UNMAPPED, denom1, -1L);
            this.write(out, "1 alignment: ", StatsMerger.STATS_LABEL.ONE_ALIGN, denom1, -1L);
            long denom1A = this.getStatistic(StatsMerger.STATS_LABEL.ONE_ALIGN);
            this.write(out, "\t1 alignment unique: ", StatsMerger.STATS_LABEL.ONE_UNIQUE, denom1, denom1A);
            this.write(out, "\t1 alignment duplicates: ", StatsMerger.STATS_LABEL.ONE_DUPS, denom1, denom1A);
            this.write(out, "2 alignments: ", StatsMerger.STATS_LABEL.TWO_ALIGN, denom1, -1L);
            long denom2A = this.getStatistic(StatsMerger.STATS_LABEL.TWO_ALIGN);
            this.write(out, "\t2 alignment unique: ", StatsMerger.STATS_LABEL.TWO_UNIQUE, denom1, denom2A);
            this.write(out, "\t2 alignment duplicates: ", StatsMerger.STATS_LABEL.TWO_DUPS, denom1, denom2A);
            this.write(out, "3 or more alignments: ", StatsMerger.STATS_LABEL.THREE_PLUS, denom1, -1L);
            this.write(out, "Ligation Motif Present: ", StatsMerger.STATS_LABEL.LIGATION_MOTIF, denom1, -1L);
            long denomAlignable = denom1A + denom2A;
            long denom2AUniq = this.getStatistic(StatsMerger.STATS_LABEL.TWO_UNIQUE);
            this.write(out, "Total Unique: ", StatsMerger.STATS_LABEL.TOTAL_UNIQUE, denom1, denomAlignable);
            this.write(out, "Total Duplicates: ", StatsMerger.STATS_LABEL.TOTAL_DUPS, denom1, denomAlignable);
            this.write(out, "Below MAPQ Threshold: ", StatsMerger.STATS_LABEL.BELOW_MAPQ, denom1, denom2AUniq);
            this.write(out, "Hi-C Contacts: ", StatsMerger.STATS_LABEL.HIC_CONTACTS, denom1, denom2AUniq);
            this.write(out, "\t3' Bias (Long Range): ", StatsMerger.STATS_LABEL.THREE_BIAS, denom1, denom2AUniq);
            if (this.getStatistic(StatsMerger.STATS_LABEL.PAIR_PERCENTS) == 25L) {
                out.write("\tPair Type %(L-I-O-R): 25% - 25% - 25% - 25%\n");
                this.write(out, "\tL-I-O-R Convergence: ", StatsMerger.STATS_LABEL.CONVERGENCE, -1L, -1L);
            }
            this.write(out, "Inter-chromosomal: ", StatsMerger.STATS_LABEL.INTER, denom1, denom2AUniq);
            this.write(out, "Intra-chromosomal: ", StatsMerger.STATS_LABEL.INTRA, denom1, denom2AUniq);
            out.write("Short Range (<20Kb):\n");
            this.write(out, "\t<500BP: ", StatsMerger.STATS_LABEL.FIVE_HUNDRED_BP, denom1, denom2AUniq);
            this.write(out, "\t500BP-5kB: ", StatsMerger.STATS_LABEL.FIVE_KB, denom1, denom2AUniq);
            this.write(out, "\t5kB-20kB: ", StatsMerger.STATS_LABEL.TWENTY_KB, denom1, denom2AUniq);
            this.write(out, "Long Range (>20Kb): ", StatsMerger.STATS_LABEL.LONG_RANGE, denom1, denom2AUniq);
            out.close();
        }
        catch (IOException error) {
            error.printStackTrace();
        }
    }

    @Override
    protected StatsMerger.STATS_LABEL parseLabel(String s) {
        if (SingleAlignmentStatsMerger.containsIgnoreCase(s, "Sequenced Reads:")) {
            return StatsMerger.STATS_LABEL.TOTAL_SEQ;
        }
        if (SingleAlignmentStatsMerger.containsIgnoreCase(s, "0 alignments:")) {
            return StatsMerger.STATS_LABEL.UNMAPPED;
        }
        if (SingleAlignmentStatsMerger.containsIgnoreCase(s, "1 alignment:")) {
            return StatsMerger.STATS_LABEL.ONE_ALIGN;
        }
        if (SingleAlignmentStatsMerger.containsIgnoreCase(s, "2 alignments:")) {
            return StatsMerger.STATS_LABEL.TWO_ALIGN;
        }
        if (SingleAlignmentStatsMerger.containsIgnoreCase(s, "1 alignment unique")) {
            return StatsMerger.STATS_LABEL.ONE_UNIQUE;
        }
        if (SingleAlignmentStatsMerger.containsIgnoreCase(s, "1 alignment duplicates")) {
            return StatsMerger.STATS_LABEL.ONE_DUPS;
        }
        if (SingleAlignmentStatsMerger.containsIgnoreCase(s, "2 alignment unique")) {
            return StatsMerger.STATS_LABEL.TWO_UNIQUE;
        }
        if (SingleAlignmentStatsMerger.containsIgnoreCase(s, "2 alignment duplicates")) {
            return StatsMerger.STATS_LABEL.TWO_DUPS;
        }
        return super.parseLabel(s);
    }
}

