/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.merge.merger;

import hic.tools.utils.merge.merger.StatsMerger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class PairedAlignmentStatsMerger
extends StatsMerger {
    @Override
    public void printToMergedFile(String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            out.write("Read type: Paired End\n");
            long denom1 = this.getStatistic(StatsMerger.STATS_LABEL.TOTAL_SEQ);
            this.write(out, "Sequenced Read Pairs: ", StatsMerger.STATS_LABEL.TOTAL_SEQ, -1L, -1L);
            this.write(out, "No chimera found: ", StatsMerger.STATS_LABEL.NO_CHIMERA, denom1, -1L);
            this.write(out, "One or both reads unmapped: ", StatsMerger.STATS_LABEL.UNMAPPED, denom1, -1L);
            this.write(out, "2 alignments: ", StatsMerger.STATS_LABEL.TWO_ALIGN, denom1, -1L);
            this.write(out, "\t2 alignments (A...B): ", StatsMerger.STATS_LABEL.TWO_ALIGN_A, denom1, -1L);
            this.write(out, "\t2 alignments (A1...A2B; A1B2...B1A2): ", StatsMerger.STATS_LABEL.TWO_ALIGN_B, denom1, -1L);
            this.write(out, "3 or more alignments: ", StatsMerger.STATS_LABEL.THREE_PLUS, denom1, -1L);
            this.write(out, "Ligation Motif Present: ", StatsMerger.STATS_LABEL.LIGATION_MOTIF, denom1, -1L);
            long denomAlignable = this.getStatistic(StatsMerger.STATS_LABEL.TWO_ALIGN);
            long denom2AUniq = this.getStatistic(StatsMerger.STATS_LABEL.TOTAL_UNIQUE);
            this.write(out, "Total Unique: ", StatsMerger.STATS_LABEL.TOTAL_UNIQUE, denom1, denomAlignable);
            this.write(out, "Total Duplicates: ", StatsMerger.STATS_LABEL.TOTAL_DUPS, denom1, denomAlignable);
            this.write(out, "Below MAPQ Threshold: ", StatsMerger.STATS_LABEL.BELOW_MAPQ, denom1, denom2AUniq);
            this.write(out, "Hi-C Contacts: ", StatsMerger.STATS_LABEL.HIC_CONTACTS, denom1, denom2AUniq);
            this.write(out, "\t3' Bias (Long Range): ", StatsMerger.STATS_LABEL.THREE_BIAS, denom1, denom2AUniq);
            if (this.getStatistic(StatsMerger.STATS_LABEL.PAIR_PERCENTS) == 25L) {
                out.write("\tPair Type %(L-I-O-R): 25% - 25% - 25% - 25%\n");
                this.write(out, "\tL-I-O-R Convergence: ", StatsMerger.STATS_LABEL.CONVERGENCE, -1L, -1L);
            }
            this.write(out, "Inter-chromosomal: ", StatsMerger.STATS_LABEL.INTER, denom1, denom2AUniq);
            this.write(out, "Intra-chromosomal: ", StatsMerger.STATS_LABEL.INTRA, denom1, denom2AUniq);
            out.write("Short Range (<20Kb):\n");
            this.write(out, "\t<500BP: ", StatsMerger.STATS_LABEL.FIVE_HUNDRED_BP, denom1, denom2AUniq);
            this.write(out, "\t500BP-5kB: ", StatsMerger.STATS_LABEL.FIVE_KB, denom1, denom2AUniq);
            this.write(out, "\t5kB-20kB: ", StatsMerger.STATS_LABEL.TWENTY_KB, denom1, denom2AUniq);
            this.write(out, "Long Range (>20Kb): ", StatsMerger.STATS_LABEL.LONG_RANGE, denom1, denom2AUniq);
            out.close();
        }
        catch (IOException error) {
            error.printStackTrace();
        }
    }

    @Override
    protected StatsMerger.STATS_LABEL parseLabel(String s) {
        if (PairedAlignmentStatsMerger.containsIgnoreCase(s, "Sequenced Read Pairs:")) {
            return StatsMerger.STATS_LABEL.TOTAL_SEQ;
        }
        if (PairedAlignmentStatsMerger.containsIgnoreCase(s, "One or both reads unmapped:")) {
            return StatsMerger.STATS_LABEL.UNMAPPED;
        }
        if (PairedAlignmentStatsMerger.containsIgnoreCase(s, "2 alignments:")) {
            return StatsMerger.STATS_LABEL.TWO_ALIGN;
        }
        if (PairedAlignmentStatsMerger.containsIgnoreCase(s, "2 alignments (A...B):")) {
            return StatsMerger.STATS_LABEL.TWO_ALIGN_A;
        }
        if (PairedAlignmentStatsMerger.containsIgnoreCase(s, "2 alignments (A1...A2B; A1B2...B1A2):")) {
            return StatsMerger.STATS_LABEL.TWO_ALIGN_B;
        }
        if (PairedAlignmentStatsMerger.containsIgnoreCase(s, "Average insert size:")) {
            return StatsMerger.STATS_LABEL.IGNORE;
        }
        return super.parseLabel(s);
    }
}

