/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.merge;

import hic.tools.utils.merge.StatsUtils;
import hic.tools.utils.merge.merger.GraphsMerger;
import hic.tools.utils.merge.merger.Merger;
import hic.tools.utils.merge.merger.PairedAlignmentStatsMerger;
import hic.tools.utils.merge.merger.SingleAlignmentStatsMerger;
import hic.tools.utils.original.HiCFileBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javastraw.reader.Dataset;

public class HiCMergeTools {
    public static void mergeStatsAndGraphs(Dataset[] datasets, File tempFolder, HiCFileBuilder builder) {
        ArrayList<String> statsList = new ArrayList<String>();
        ArrayList<String> graphsList = new ArrayList<String>();
        for (Dataset ds : datasets) {
            HiCMergeTools.addToListIfValidString(ds.getStatistics(), statsList);
            HiCMergeTools.addToListIfValidString(ds.getGraphs(), graphsList);
        }
        if (statsList.size() > 0) {
            boolean isSingleAlignment = HiCMergeTools.confirmAllSingleAlignment(statsList);
            String statsPath = new File(tempFolder, "stats.txt").getAbsolutePath();
            if (isSingleAlignment) {
                StatsUtils.merge(statsList, new SingleAlignmentStatsMerger(), statsPath);
            } else {
                StatsUtils.merge(statsList, new PairedAlignmentStatsMerger(), statsPath);
            }
            builder.setStatisticsFile(statsPath);
        }
        if (graphsList.size() > 0) {
            String graphsPath = new File(tempFolder, "graphs_hists.m").getAbsolutePath();
            StatsUtils.merge(graphsList, new GraphsMerger(), graphsPath);
            builder.setGraphFile(graphsPath);
        }
    }

    private static void addToListIfValidString(String info, List<String> infoList) {
        if (info != null && info.length() > 1) {
            infoList.add(info);
        }
    }

    private static boolean confirmAllSingleAlignment(List<String> statsList) {
        boolean hasSingleAlignment = false;
        boolean hasPairedAlignment = false;
        for (String s : statsList) {
            hasSingleAlignment |= Merger.containsIgnoreCase(s, "Read type: Single End");
            hasPairedAlignment |= Merger.containsIgnoreCase(s, "Read type: Paired End");
        }
        if (hasSingleAlignment && hasPairedAlignment) {
            System.err.println("Cannot mix single-end and paired-end files together");
            System.exit(9);
        }
        return hasSingleAlignment;
    }
}

