/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.localtemps;

import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javastraw.reader.Dataset;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.iterators.GenomeWideIterator;
import javastraw.reader.type.HiCZoom;

public class BinRecordsWriter {
    private static int internalCount = 0;

    public static void saveAllContacts(Iterator<ContactRecord> iterator2, int limit, List<String> filenames, String stem) throws IOException {
        LittleEndianOutputStream les = BinRecordsWriter.createNewTempFile(filenames, stem);
        int counter = 0;
        while (iterator2.hasNext()) {
            ContactRecord record = iterator2.next();
            les.writeInt(record.getBinX());
            les.writeInt(record.getBinY());
            les.writeFloat(record.getCounts());
            if (++counter < limit) continue;
            les.close();
            les = BinRecordsWriter.createNewTempFile(filenames, stem);
            counter = 0;
        }
        if (counter > 0) {
            les.close();
        }
    }

    private static LittleEndianOutputStream createNewTempFile(List<String> files, String stem) throws IOException {
        File tempFile = File.createTempFile(stem + internalCount++, ".tmp.bin");
        tempFile.deleteOnExit();
        files.add(tempFile.getAbsolutePath());
        BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(tempFile.toPath(), new OpenOption[0]));
        return new LittleEndianOutputStream(bos);
    }

    public static void saveAllGWContacts(Dataset ds, ChromosomeHandler handler, HiCZoom zoom, boolean includeIntra, int limit, List<String> filenames, String intraStem, String interStem) {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        Runnable worker = () -> {
            try {
                BinRecordsWriter.saveAllContacts(new GenomeWideIterator(ds, handler, zoom, false, true), limit, filenames, interStem);
            }
            catch (IOException e) {
                System.err.println("Unable to save inter data to local files");
                e.printStackTrace();
                System.exit(31);
            }
        };
        executor.execute(worker);
        if (includeIntra) {
            Runnable worker2 = () -> {
                try {
                    BinRecordsWriter.saveAllContacts(new GenomeWideIterator(ds, handler, zoom, true, false), limit, filenames, intraStem);
                }
                catch (IOException e) {
                    System.err.println("Unable to save intra data to local files");
                    e.printStackTrace();
                    System.exit(31);
                }
            };
            executor.execute(worker2);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
    }
}

