/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.localtemps;

import htsjdk.tribble.util.LittleEndianInputStream;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Iterator;
import javastraw.reader.block.ContactRecord;

public class BinRecordsReader
implements Iterator<ContactRecord> {
    protected final LittleEndianInputStream is;
    protected ContactRecord next;

    public BinRecordsReader(String path) throws IOException {
        this.is = new LittleEndianInputStream(new BufferedInputStream(Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0])));
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public ContactRecord next() {
        ContactRecord retValue = this.next;
        this.advance();
        return retValue;
    }

    @Override
    public void remove() {
    }

    public void close() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void advance() {
        block2: {
            try {
                int binX = this.is.readInt();
                int binY = this.is.readInt();
                float val = this.is.readFloat();
                this.next = new ContactRecord(binX, binY, val);
            }
            catch (IOException e) {
                this.next = null;
                if (e instanceof EOFException) break block2;
                e.printStackTrace();
            }
        }
    }
}

