/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.largelists;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.tdf.BufferedByteWriter;

public class BigListOfByteWriters {
    final List<BufferedByteWriter> bufferList = new ArrayList<BufferedByteWriter>();
    private int internalCounter = 1;

    public BigListOfByteWriters() {
        this.expandBuffer();
    }

    public void putInt(int value) throws IOException {
        this.bufferList.get(this.index()).putInt(value);
    }

    public void putLong(long value) throws IOException {
        this.bufferList.get(this.index()).putLong(value);
    }

    public void putFloat(float value) throws IOException {
        this.bufferList.get(this.index()).putFloat(value);
    }

    public void putNullTerminatedString(String value) throws IOException {
        this.bufferList.get(this.index()).putNullTerminatedString(value);
    }

    public void expandBufferIfNeeded(int buffer) {
        if (Integer.MAX_VALUE - this.bufferList.get(this.index()).bytesWritten() < buffer) {
            this.bufferList.add(new BufferedByteWriter());
        }
    }

    public void expandBufferIfNeededPerCounter(int buffer, int divisor) {
        if (++this.internalCounter % divisor == 0) {
            if (Integer.MAX_VALUE - this.bufferList.get(this.index()).bytesWritten() < buffer) {
                this.bufferList.add(new BufferedByteWriter());
            }
            this.internalCounter = 1;
        }
    }

    private int index() {
        return this.bufferList.size() - 1;
    }

    public void expandBuffer() {
        this.bufferList.add(new BufferedByteWriter());
    }

    public long getBytesWritten() {
        long total = 0L;
        for (BufferedByteWriter bufferedByteWriter : this.bufferList) {
            total += (long)bufferedByteWriter.bytesWritten();
        }
        return total;
    }

    public void writeToOutput(OutputStream los) throws IOException {
        for (BufferedByteWriter writer : this.bufferList) {
            los.write(writer.getBytes());
        }
    }

    public void writeToRAF(RandomAccessFile raf) throws IOException {
        for (BufferedByteWriter writer : this.bufferList) {
            raf.write(writer.getBytes());
        }
    }
}

