/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.largelists;

import hic.HiCGlobals;
import hic.tools.utils.largelists.BigFloatsArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.tools.ParallelizationTools;

public class BigIntsArray {
    public static final int DEFAULT_LENGTH = 10000;
    final long overallLength;
    final List<int[]> internalList = new ArrayList<int[]>();

    public BigIntsArray(long length) {
        this.overallLength = length;
        for (long tempLength = length; tempLength > 0L; tempLength -= 10000L) {
            if (tempLength < 10000L) {
                this.internalList.add(new int[(int)tempLength]);
                break;
            }
            this.internalList.add(new int[10000]);
        }
    }

    public BigIntsArray(long totSize, short defaultValue) {
        this(totSize);
        for (int[] array : this.internalList) {
            Arrays.fill(array, (int)defaultValue);
        }
    }

    public void clear() {
        this.internalList.clear();
    }

    public int get(long index) {
        if (index < this.overallLength) {
            int pseudoRow = (int)(index / 10000L);
            int pseudoCol = (int)(index % 10000L);
            return this.internalList.get(pseudoRow)[pseudoCol];
        }
        System.err.println("long index exceeds max size of list of int arrays while getting");
        return -2147483647;
    }

    public void set(long index, short value) {
        if (index < this.overallLength) {
            int pseudoRow = (int)(index / 10000L);
            int pseudoCol = (int)(index % 10000L);
            this.internalList.get((int)pseudoRow)[pseudoCol] = value;
        } else {
            System.err.println("long index exceeds max size of list of arrays while setting");
        }
    }

    public long getLength() {
        return this.overallLength;
    }

    public BigFloatsArray deepConvertedClone() {
        BigFloatsArray clone = new BigFloatsArray(this.overallLength);
        for (int k = 0; k < this.internalList.size(); ++k) {
            float[] dest = clone.internalList.get(k);
            int[] src = this.internalList.get(k);
            for (int q = 0; q < dest.length; ++q) {
                dest[q] = src[q];
            }
        }
        return clone;
    }

    public List<int[]> getValues() {
        return this.internalList;
    }

    public void parSetTo(BigFloatsArray srcArrays) {
        AtomicInteger index = new AtomicInteger();
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int i = index.getAndIncrement();
            while (i < this.internalList.size()) {
                int[] dest = this.internalList.get(i);
                float[] src = srcArrays.internalList.get(i);
                for (int z = 0; z < dest.length; ++z) {
                    dest[z] = (short)src[z];
                }
                i = index.getAndIncrement();
            }
        });
    }

    public BigIntsArray deepClone() {
        BigIntsArray clone = new BigIntsArray(this.overallLength);
        for (int k = 0; k < this.internalList.size(); ++k) {
            System.arraycopy(this.internalList.get(k), 0, clone.internalList.get(k), 0, this.internalList.get(k).length);
        }
        return clone;
    }

    private int getNumThreads() {
        return Math.min(HiCGlobals.normThreads, this.internalList.size());
    }
}

