/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.largelists;

import com.google.common.util.concurrent.AtomicDouble;
import hic.HiCGlobals;
import hic.tools.utils.largelists.BigIntsArray;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.reader.datastructures.ListOfFloatArrays;
import javastraw.tools.ParallelizationTools;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class BigFloatsArray {
    final long DEFAULT_LENGTH = 10000L;
    final long overallLength;
    final List<float[]> internalList = new ArrayList<float[]>();

    public BigFloatsArray(long length) {
        this.overallLength = length;
        for (long tempLength = length; tempLength > 0L; tempLength -= 10000L) {
            if (tempLength < 10000L) {
                this.internalList.add(new float[(int)tempLength]);
                break;
            }
            this.internalList.add(new float[10000]);
        }
    }

    public void clear() {
        this.internalList.clear();
    }

    public float get(long index) {
        if (index < this.overallLength) {
            int pseudoRow = (int)(index / 10000L);
            int pseudoCol = (int)(index % 10000L);
            return this.internalList.get(pseudoRow)[pseudoCol];
        }
        System.err.println("long index exceeds max size of list of arrays while getting: " + index + " " + this.overallLength);
        Exception ioe = new Exception();
        ioe.printStackTrace();
        return Float.NaN;
    }

    public void set(long index, float value) {
        if (index < this.overallLength) {
            int pseudoRow = (int)(index / 10000L);
            int pseudoCol = (int)(index % 10000L);
            this.internalList.get((int)pseudoRow)[pseudoCol] = value;
        } else {
            System.err.println("long index exceeds max size of list of arrays while setting");
        }
    }

    public void add(long index, float value) {
        if (index < this.overallLength) {
            int pseudoRow = (int)(index / 10000L);
            int pseudoCol = (int)(index % 10000L);
            float[] fArray = this.internalList.get(pseudoRow);
            int n = pseudoCol;
            fArray[n] = fArray[n] + value;
        } else {
            System.err.println("long index exceeds max size of list of arrays while setting");
        }
    }

    public long getLength() {
        return this.overallLength;
    }

    public BigFloatsArray deepClone() {
        BigFloatsArray clone = new BigFloatsArray(this.overallLength);
        for (int k = 0; k < this.internalList.size(); ++k) {
            System.arraycopy(this.internalList.get(k), 0, clone.internalList.get(k), 0, this.internalList.get(k).length);
        }
        return clone;
    }

    public void multiplyBy(long index, float value) {
        if (index < this.overallLength) {
            int pseudoRow = (int)(index / 10000L);
            int pseudoCol = (int)(index % 10000L);
            float[] fArray = this.internalList.get(pseudoRow);
            int n = pseudoCol;
            fArray[n] = fArray[n] * value;
        } else {
            System.err.println("long index exceeds max size of list of arrays while mutiplying");
        }
    }

    public List<float[]> getValues() {
        return this.internalList;
    }

    public ListOfFloatArrays convertToRegular() {
        ListOfFloatArrays clone = new ListOfFloatArrays(this.overallLength);
        for (long k = 0L; k < this.getLength(); ++k) {
            clone.set(k, this.get(k));
        }
        return clone;
    }

    public static double parCalculateError(BigFloatsArray col, BigFloatsArray scale, BigIntsArray target, BigIntsArray bad) {
        AtomicDouble atomicDouble = new AtomicDouble(0.0);
        AtomicInteger index = new AtomicInteger();
        ParallelizationTools.launchParallelizedCode(col.getNumThreads(), () -> {
            int i = index.getAndIncrement();
            float err = 0.0f;
            while (i < col.internalList.size()) {
                float[] colA = col.internalList.get(i);
                float[] scaleA = scale.internalList.get(i);
                int[] targetA = target.internalList.get(i);
                int[] badA = bad.internalList.get(i);
                for (int z = 0; z < colA.length; ++z) {
                    float tempErr;
                    if (badA[z] == 1 || !((tempErr = Math.abs(colA[z] * scaleA[z] - (float)targetA[z])) > err)) continue;
                    err = tempErr;
                }
                i = index.getAndIncrement();
            }
            AtomicDouble atomicDouble2 = atomicDouble;
            synchronized (atomicDouble2) {
                if ((double)err > atomicDouble.get()) {
                    atomicDouble.set(err);
                }
            }
        });
        return atomicDouble.get();
    }

    public static double calculateError90(BigFloatsArray col, BigFloatsArray scale, BigIntsArray target, BigIntsArray bad) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int i = 0; i < col.internalList.size(); ++i) {
            float[] colA = col.internalList.get(i);
            float[] scaleA = scale.internalList.get(i);
            int[] targetA = target.internalList.get(i);
            int[] badA = bad.internalList.get(i);
            for (int z = 0; z < colA.length; ++z) {
                if (badA[z] == 1) continue;
                float tempErr = Math.abs(colA[z] * scaleA[z] - (float)targetA[z]);
                stats.addValue(tempErr);
            }
        }
        return stats.getPercentile(90.0);
    }

    public static double parCalculateConvergenceError(BigFloatsArray calculatedVectorB, BigFloatsArray current, BigIntsArray bad) {
        AtomicDouble atomicDouble = new AtomicDouble(0.0);
        AtomicInteger index = new AtomicInteger();
        ParallelizationTools.launchParallelizedCode(current.getNumThreads(), () -> {
            int i = index.getAndIncrement();
            double err = 0.0;
            while (i < current.internalList.size()) {
                float[] calcA = calculatedVectorB.internalList.get(i);
                float[] currA = current.internalList.get(i);
                int[] badA = bad.internalList.get(i);
                for (int z = 0; z < calcA.length; ++z) {
                    double relativeErr;
                    if (badA[z] == 1 || !((relativeErr = (double)Math.abs((calcA[z] - currA[z]) / (calcA[z] + currA[z]))) > err)) continue;
                    err = relativeErr;
                }
                i = index.getAndIncrement();
            }
            AtomicDouble atomicDouble2 = atomicDouble;
            synchronized (atomicDouble2) {
                if (err > atomicDouble.get()) {
                    atomicDouble.set(err);
                }
            }
        });
        return atomicDouble.get();
    }

    public void parSetToGeoMean(BigFloatsArray a, BigFloatsArray b) {
        AtomicInteger index = new AtomicInteger();
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int i = index.getAndIncrement();
            while (i < this.internalList.size()) {
                float[] result = this.internalList.get(i);
                float[] a1 = a.internalList.get(i);
                float[] b1 = b.internalList.get(i);
                for (int p = 0; p < result.length; ++p) {
                    result[p] = (float)Math.sqrt(a1[p] * b1[p]);
                }
                i = index.getAndIncrement();
            }
        });
    }

    public void parSetTo(BigFloatsArray srcArrays) {
        AtomicInteger index = new AtomicInteger();
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int i = index.getAndIncrement();
            while (i < this.internalList.size()) {
                float[] dest = this.internalList.get(i);
                float[] src = srcArrays.internalList.get(i);
                System.arraycopy(src, 0, dest, 0, dest.length);
                i = index.getAndIncrement();
            }
        });
    }

    public void parMultiplyByOneMinus(BigIntsArray array) {
        AtomicInteger index = new AtomicInteger();
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int i = index.getAndIncrement();
            while (i < this.internalList.size()) {
                float[] orig = this.internalList.get(i);
                int[] arr = array.internalList.get(i);
                for (int p = 0; p < orig.length; ++p) {
                    int n = p;
                    orig[n] = orig[n] * (float)(1 - arr[p]);
                }
                i = index.getAndIncrement();
            }
        });
    }

    public void parMultiplyBy(BigFloatsArray dv) {
        AtomicInteger index = new AtomicInteger();
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int i = index.getAndIncrement();
            while (i < this.internalList.size()) {
                float[] orig = this.internalList.get(i);
                float[] arr = dv.internalList.get(i);
                for (int p = 0; p < orig.length; ++p) {
                    int n = p;
                    orig[n] = orig[n] * arr[p];
                }
                i = index.getAndIncrement();
            }
        });
    }

    public void parSetToDivision(BigIntsArray num, BigFloatsArray denom) {
        AtomicInteger index = new AtomicInteger();
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int i = index.getAndIncrement();
            while (i < this.internalList.size()) {
                float[] orig = this.internalList.get(i);
                int[] num1 = num.internalList.get(i);
                float[] denom1 = denom.internalList.get(i);
                for (int p = 0; p < orig.length; ++p) {
                    orig[p] = (float)num1[p] / denom1[p];
                }
                i = index.getAndIncrement();
            }
        });
    }

    private int getNumThreads() {
        return Math.min(HiCGlobals.normThreads, this.internalList.size());
    }

    public void parScaleByRatio(BigIntsArray num, BigFloatsArray denom) {
        AtomicInteger index = new AtomicInteger();
        ParallelizationTools.launchParallelizedCode(this.getNumThreads(), () -> {
            int i = index.getAndIncrement();
            while (i < this.internalList.size()) {
                float[] orig = this.internalList.get(i);
                int[] num1 = num.internalList.get(i);
                float[] denom1 = denom.internalList.get(i);
                for (int p = 0; p < orig.length; ++p) {
                    int n = p;
                    orig[n] = orig[n] * ((float)num1[p] / denom1[p]);
                }
                i = index.getAndIncrement();
            }
        });
    }

    public void addValuesFrom(BigFloatsArray other) {
        if (this.overallLength == other.overallLength) {
            for (int i = 0; i < this.internalList.size(); ++i) {
                for (int j = 0; j < this.internalList.get(i).length; ++j) {
                    float[] fArray = this.internalList.get(i);
                    int n = j;
                    fArray[n] = fArray[n] + other.internalList.get(i)[j];
                }
            }
        } else {
            System.err.println("Adding objects of different sizes!");
        }
    }
}

