/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.iterators.mnd;

import hic.tools.utils.iterators.mnd.GenericPairIterator;
import hic.tools.utils.iterators.mnd.MNDFileParser;
import hic.tools.utils.iterators.mnd.PairIterator;
import hic.tools.utils.iterators.mnd.SimpleLineParser;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.broad.igv.util.ParsingUtils;

public class SimpleAsciiPairIterator
extends GenericPairIterator
implements PairIterator {
    public SimpleAsciiPairIterator(String path) throws IOException {
        super(new MNDFileParser(new SimpleLineParser()));
        if (path.endsWith(".gz")) {
            GZIPInputStream gzipStream = new GZIPInputStream(new FileInputStream(path));
            InputStreamReader decoder = new InputStreamReader((InputStream)gzipStream, StandardCharsets.UTF_8);
            this.reader = new BufferedReader(decoder, 0x400000);
        } else {
            this.reader = new BufferedReader(new InputStreamReader(ParsingUtils.openInputStream(path)), 0x200000);
        }
        this.advance();
    }

    public String getChromosomeNameFromIndex(int chrIndex) {
        return this.mndFileParser.getChromosomeNameFromIndex(chrIndex);
    }
}

