/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.iterators.mnd;

import hic.tools.utils.iterators.mnd.AlignmentPair;

public class ReadPairFilter {
    private final Type type;

    public ReadPairFilter(Type type) {
        this.type = type;
    }

    protected static Type calculateType(AlignmentPair pair) {
        if (pair.getStrand1() == pair.getStrand2()) {
            if (pair.getStrand1()) {
                return Type.RR;
            }
            return Type.LL;
        }
        if (pair.getStrand1()) {
            if (pair.getPos1() < pair.getPos2()) {
                return Type.INNER;
            }
            return Type.OUTER;
        }
        if (pair.getPos1() < pair.getPos2()) {
            return Type.OUTER;
        }
        return Type.INNER;
    }

    public boolean pairTypesAreEqual(AlignmentPair pair) {
        return this.pairTypesAreEqual(ReadPairFilter.calculateType(pair));
    }

    protected boolean pairTypesAreEqual(Type pairType) {
        if (this.type == pairType) {
            return true;
        }
        if (this.type == Type.TANDEM) {
            return pairType == Type.LL || pairType == Type.RR;
        }
        return false;
    }

    public static enum Type {
        INNER,
        OUTER,
        LL,
        RR,
        TANDEM;

    }
}

