/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.iterators.mnd;

import hic.tools.utils.iterators.mnd.AlignmentPair;
import hic.tools.utils.iterators.mnd.AsciiPairIterator;
import hic.tools.utils.iterators.mnd.BinPairIterator;
import hic.tools.utils.iterators.mnd.ShortBinPairIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javastraw.reader.basics.ChromosomeHandler;

public interface PairIterator
extends Iterator<AlignmentPair> {
    @Override
    public boolean hasNext();

    @Override
    public AlignmentPair next();

    @Override
    public void remove();

    public void close();

    public static PairIterator getIterator(String file, Map<String, Integer> chromosomeIndexes, ChromosomeHandler chromosomeHandler) throws IOException {
        if (file.endsWith(".bin")) {
            return new BinPairIterator(file);
        }
        if (file.endsWith(".bn")) {
            return new ShortBinPairIterator(file);
        }
        return new AsciiPairIterator(file, chromosomeIndexes, chromosomeHandler, false);
    }
}

