/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.iterators.mnd;

import hic.tools.utils.iterators.mnd.AlignmentPair;
import java.util.HashMap;
import java.util.Map;

public abstract class MNDLineParser {
    private final Map<String, String> stringInternPool = new HashMap<String, String>();

    protected abstract int getChromosomeOrdinal(String var1);

    public abstract String getChromosomeNameFromIndex(int var1);

    public abstract AlignmentPair generateBasicPair(String[] var1, int var2, int var3, int var4, int var5);

    protected AlignmentPair createPair(String[] tokens2, String chrom1, String chrom2, int pos1Index, int pos2Index) {
        int chr1 = this.getChromosomeOrdinal(chrom1);
        int chr2 = this.getChromosomeOrdinal(chrom2);
        int pos1 = Integer.parseInt(tokens2[pos1Index]);
        int pos2 = Integer.parseInt(tokens2[pos2Index]);
        return new AlignmentPair(chr1, pos1, chr2, pos2);
    }

    public AlignmentPair generateMediumPair(String[] tokens2, int chrom1Index, int chrom2Index, int pos1Index, int pos2Index, int frag1Index, int frag2Index, int mapq1Index, int mapq2Index, int strand1Index, int strand2Index) {
        AlignmentPair nextPair = this.generateBasicPair(tokens2, chrom1Index, chrom2Index, pos1Index, pos2Index);
        this.updateFragmentsForPair(nextPair, tokens2, frag1Index, frag2Index);
        this.updateMAPQsForPair(nextPair, tokens2, mapq1Index, mapq2Index);
        this.updateStrandsForPair(nextPair, tokens2, strand1Index, strand2Index);
        return nextPair;
    }

    public void updateStrandsForPair(AlignmentPair nextPair, String[] tokens2, int strand1Index, int strand2Index) {
        boolean strand1 = Integer.parseInt(tokens2[strand1Index]) == 0;
        boolean strand2 = Integer.parseInt(tokens2[strand2Index]) == 0;
        nextPair.updateStrands(strand1, strand2);
    }

    public void updateDCICStrandsForPair(AlignmentPair nextPair, String[] tokens2, int strand1Index, int strand2Index) {
        boolean strand1 = tokens2[strand1Index].equals("+");
        boolean strand2 = tokens2[strand2Index].equals("+");
        nextPair.updateStrands(strand1, strand2);
    }

    public void updateMAPQsForPair(AlignmentPair nextPair, String[] tokens2, int mapq1Index, int mapq2Index) {
        int mapq1 = Integer.parseInt(tokens2[mapq1Index]);
        int mapq2 = Integer.parseInt(tokens2[mapq2Index]);
        nextPair.updateMAPQs(mapq1, mapq2);
    }

    public void updateFragmentsForPair(AlignmentPair nextPair, String[] tokens2, int frag1Index, int frag2Index) {
        int frag1 = Integer.parseInt(tokens2[frag1Index]);
        int frag2 = Integer.parseInt(tokens2[frag2Index]);
        nextPair.updateFragments(frag1, frag2);
    }

    public void updatePairScoreIfNeeded(boolean includeScore, AlignmentPair nextPair, String[] tokens2, int scoreIndex) {
        if (includeScore) {
            nextPair.setScore(Float.parseFloat(tokens2[scoreIndex]));
        }
    }

    protected String getInternedString(String aString) {
        String s = this.stringInternPool.get(aString);
        if (s == null) {
            s = new String(aString);
            this.stringInternPool.put(aString, s);
        }
        return s;
    }
}

