/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.iterators.mnd;

import hic.tools.clt.JuiceboxCLT;
import hic.tools.utils.iterators.mnd.AlignmentPair;
import hic.tools.utils.iterators.mnd.AlignmentPairLong;
import hic.tools.utils.iterators.mnd.MNDLineParser;
import java.io.IOException;

public class MNDFileParser {
    protected static final int dcicF1 = 0;
    protected static final int dcicF2 = 1;
    protected static final int dcicM1 = 2;
    protected static final int dcicM2 = 3;
    public static final String[] dcicCategories = new String[]{"frag1", "frag2", "mapq1", "mapq2"};
    protected final int[] dcicIndices = new int[]{-1, -1, -1, -1};
    private final MNDLineParser pg;
    private Format format = null;

    MNDFileParser(MNDLineParser pg) {
        this.pg = pg;
    }

    public static Format getFileFormat(int nTokens, String nextLine) throws IOException {
        if (nTokens == 4) {
            return Format.SUPER_SHORT;
        }
        if (nTokens == 5) {
            return Format.SUPER_SHORT_WITH_SCORE;
        }
        if (nTokens == 8) {
            return Format.SHORT;
        }
        if (nTokens == 9) {
            return Format.SHORT_WITH_SCORE;
        }
        if (nTokens == 16) {
            return Format.LONG;
        }
        if (nTokens == 11) {
            return Format.MEDIUM;
        }
        throw new IOException("Unexpected number of columns: " + nTokens + "\nCheck line containing:\n" + nextLine);
    }

    public AlignmentPair parse(String nextLine) throws IOException {
        String[] tokens2 = JuiceboxCLT.splitToList(nextLine);
        if (this.format == null) {
            int nTokens = tokens2.length;
            if (nextLine.startsWith("#")) {
                this.format = Format.DCIC;
                this.updateDCICIndicesIfApplicable(nextLine, tokens2);
                return new AlignmentPair(true);
            }
            this.format = MNDFileParser.getFileFormat(nTokens, nextLine);
        }
        if (this.format == Format.MEDIUM) {
            return this.parseMediumFormat(tokens2);
        }
        if (this.format == Format.LONG) {
            return this.parseLongFormat(tokens2);
        }
        if (this.format == Format.DCIC) {
            return this.parseDCICFormat(tokens2);
        }
        if (this.format == Format.SUPER_SHORT || this.format == Format.SUPER_SHORT_WITH_SCORE) {
            return this.parseSuperShortFormat(tokens2, this.format == Format.SUPER_SHORT_WITH_SCORE);
        }
        return this.parseShortFormat(tokens2, this.format == Format.SHORT_WITH_SCORE);
    }

    public void updateDCICIndicesIfApplicable(String nextLine, String[] tokens2) {
        if (nextLine.contains("column")) {
            for (int i = 0; i < tokens2.length; ++i) {
                for (int k = 0; k < dcicCategories.length; ++k) {
                    if (!tokens2[i].contains(dcicCategories[k])) continue;
                    this.dcicIndices[k] = i - 1;
                }
            }
        }
    }

    public AlignmentPair parseShortFormat(String[] tokens2, boolean includeScore) {
        AlignmentPair nextPair = this.pg.generateBasicPair(tokens2, 1, 5, 2, 6);
        this.pg.updatePairScoreIfNeeded(includeScore, nextPair, tokens2, 8);
        this.pg.updateFragmentsForPair(nextPair, tokens2, 3, 7);
        this.pg.updateStrandsForPair(nextPair, tokens2, 0, 4);
        return nextPair;
    }

    public AlignmentPair parseSuperShortFormat(String[] tokens2, boolean includeScore) {
        AlignmentPair nextPair = this.pg.generateBasicPair(tokens2, 0, 2, 1, 3);
        this.pg.updatePairScoreIfNeeded(includeScore, nextPair, tokens2, 4);
        return nextPair;
    }

    public AlignmentPair parseDCICFormat(String[] tokens2) {
        AlignmentPair nextPair = this.pg.generateBasicPair(tokens2, 1, 3, 2, 4);
        this.pg.updateDCICStrandsForPair(nextPair, tokens2, 5, 6);
        if (this.dcicIndices[0] != -1 && this.dcicIndices[1] != -1) {
            this.pg.updateFragmentsForPair(nextPair, tokens2, this.dcicIndices[0], this.dcicIndices[1]);
        }
        if (this.dcicIndices[2] != -1 && this.dcicIndices[3] != -1) {
            this.pg.updateMAPQsForPair(nextPair, tokens2, this.dcicIndices[2], this.dcicIndices[3]);
        }
        return nextPair;
    }

    public AlignmentPair parseLongFormat(String[] tokens2) {
        AlignmentPair nextPair = this.pg.generateMediumPair(tokens2, 1, 5, 2, 6, 3, 7, 8, 11, 0, 4);
        return new AlignmentPairLong(nextPair, tokens2[10], tokens2[13]);
    }

    public AlignmentPair parseMediumFormat(String[] tokens2) {
        return this.pg.generateMediumPair(tokens2, 2, 6, 3, 7, 4, 8, 9, 10, 1, 5);
    }

    public String getChromosomeNameFromIndex(int chrIndex) {
        return this.pg.getChromosomeNameFromIndex(chrIndex);
    }

    static enum Format {
        SUPER_SHORT,
        SUPER_SHORT_WITH_SCORE,
        SHORT,
        LONG,
        MEDIUM,
        SHORT_WITH_SCORE,
        DCIC;

    }
}

