/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.iterators.mnd;

import hic.tools.utils.iterators.mnd.AlignmentPair;
import hic.tools.utils.iterators.mnd.MNDFileParser;
import hic.tools.utils.iterators.mnd.PairIterator;
import java.io.BufferedReader;
import java.io.IOException;

public abstract class GenericPairIterator
implements PairIterator {
    protected final MNDFileParser mndFileParser;
    protected AlignmentPair nextPair = null;
    protected BufferedReader reader;

    public GenericPairIterator(MNDFileParser mndFileParser) {
        this.mndFileParser = mndFileParser;
    }

    @Override
    public boolean hasNext() {
        return this.nextPair != null;
    }

    @Override
    public AlignmentPair next() {
        AlignmentPair p = this.nextPair;
        this.advance();
        return p;
    }

    protected void advance() {
        try {
            String nextLine = this.reader.readLine();
            nextLine = this.validateLine(nextLine);
            if (nextLine != null) {
                this.nextPair = this.mndFileParser.parse(nextLine);
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.nextPair = null;
    }

    protected String validateLine(String nextLine) {
        return nextLine;
    }

    @Override
    public void remove() {
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

