/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.iterators.mnd;

import hic.tools.utils.iterators.mnd.AlignmentPair;
import hic.tools.utils.iterators.mnd.MNDLineParser;
import java.util.Map;
import javastraw.reader.basics.ChromosomeHandler;

public class ComplexLineParser
extends MNDLineParser {
    private final Map<String, Integer> chromosomeOrdinals;
    private final boolean allowNewChroms;
    private final ChromosomeHandler handler;
    private int chromCounter = -1;

    ComplexLineParser(Map<String, Integer> chromosomeOrdinals, ChromosomeHandler handler, boolean allowNewChroms, boolean shouldUpdateCounter) {
        this.chromosomeOrdinals = chromosomeOrdinals;
        this.allowNewChroms = allowNewChroms;
        this.handler = handler;
        if (shouldUpdateCounter) {
            this.updateChromCounter();
        }
    }

    @Override
    protected int getChromosomeOrdinal(String chrom) {
        return this.chromosomeOrdinals.get(chrom);
    }

    @Override
    public AlignmentPair generateBasicPair(String[] tokens2, int chrom1Index, int chrom2Index, int pos1Index, int pos2Index) {
        String chrom2;
        String chrom1 = this.handler.cleanUpName(this.getInternedString(tokens2[chrom1Index]));
        if (this.isValid(chrom1, chrom2 = this.handler.cleanUpName(this.getInternedString(tokens2[chrom2Index])))) {
            return this.createPair(tokens2, chrom1, chrom2, pos1Index, pos2Index);
        }
        return new AlignmentPair();
    }

    @Override
    public String getChromosomeNameFromIndex(int chrIndex) {
        return this.handler.getChromosomeFromIndex(chrIndex).getName();
    }

    private void updateOrdinalsMap(String chrom) {
        if (!this.chromosomeOrdinals.containsKey(chrom)) {
            this.chromosomeOrdinals.put(chrom, this.chromCounter++);
        }
    }

    private void updateChromCounter() {
        for (Integer val : this.chromosomeOrdinals.values()) {
            this.chromCounter = Math.max(this.chromCounter, val);
        }
        ++this.chromCounter;
    }

    private boolean isValid(String chrom1, String chrom2) {
        if (this.chromosomeOrdinals.containsKey(chrom1) && this.chromosomeOrdinals.containsKey(chrom2)) {
            return true;
        }
        if (this.allowNewChroms) {
            this.updateOrdinalsMap(chrom1);
            this.updateOrdinalsMap(chrom2);
            return true;
        }
        return false;
    }
}

