/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.iterators.mnd;

import hic.tools.utils.iterators.mnd.AlignmentPair;
import hic.tools.utils.iterators.mnd.PairIterator;
import htsjdk.tribble.util.LittleEndianInputStream;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;

public class BinPairIterator
implements PairIterator {
    protected final LittleEndianInputStream is;
    protected AlignmentPair next;
    private AlignmentPair preNext;

    public BinPairIterator(String path) throws IOException {
        this.is = new LittleEndianInputStream(new BufferedInputStream(new FileInputStream(path)));
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.preNext != null || this.next != null;
    }

    @Override
    public AlignmentPair next() {
        AlignmentPair retValue;
        if (this.preNext == null) {
            retValue = this.next;
            this.advance();
        } else {
            retValue = this.preNext;
            this.preNext = null;
        }
        return retValue;
    }

    @Override
    public void remove() {
    }

    @Override
    public void close() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void advance() {
        block2: {
            try {
                boolean str1 = this.is.readByte() != 0;
                int chr1 = this.is.readInt();
                int pos1 = this.is.readInt();
                int frag1 = this.is.readInt();
                boolean str2 = this.is.readByte() != 0;
                int chr2 = this.is.readInt();
                int pos2 = this.is.readInt();
                int frag2 = this.is.readInt();
                this.next = new AlignmentPair(str1, chr1, pos1, frag1, str2, chr2, pos2, frag2);
            }
            catch (IOException e) {
                this.next = null;
                if (e instanceof EOFException) break block2;
                e.printStackTrace();
            }
        }
    }
}

