/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.iterators.mnd;

import hic.tools.utils.iterators.mnd.AlignmentPair;
import hic.tools.utils.iterators.mnd.PairIterator;
import htsjdk.samtools.util.CloseableIterator;
import java.io.IOException;
import java.util.Map;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;

public class BAMPairIterator
implements PairIterator {
    private AlignmentPair nextPair = null;
    private AlignmentPair preNext = null;
    private final CloseableIterator<?> iterator;
    private final AlignmentReader<?> reader;
    private Map<String, Integer> chromosomeOrdinals;

    public BAMPairIterator(String path) throws IOException {
        this.reader = AlignmentReaderFactory.getReader(path, false);
        this.iterator = this.reader.iterator();
        this.advance();
    }

    private void advance() {
        while (this.iterator.hasNext()) {
            Alignment alignment = (Alignment)this.iterator.next();
            ReadMate mate = alignment.getMate();
            if (!alignment.isPaired() || !alignment.isMapped() || alignment.getMappingQuality() <= 0 || mate == null || !mate.isMapped() || alignment.getChr().equals(mate.getChr()) && alignment.getInferredInsertSize() <= 1000 || (!alignment.getChr().equals(mate.getChr()) || alignment.getStart() >= mate.getStart()) && alignment.getChr().compareTo(mate.getChr()) >= 0) continue;
            String chrom1 = alignment.getChr();
            String chrom2 = mate.getChr();
            if (this.chromosomeOrdinals.containsKey(chrom1) && this.chromosomeOrdinals.containsKey(chrom2)) {
                int chr1 = this.chromosomeOrdinals.get(chrom1);
                int n = this.chromosomeOrdinals.get(chrom2);
            }
            return;
        }
        this.nextPair = null;
    }

    @Override
    public boolean hasNext() {
        return this.preNext != null || this.nextPair != null;
    }

    @Override
    public AlignmentPair next() {
        AlignmentPair p;
        if (this.preNext == null) {
            p = this.nextPair;
            this.advance();
        } else {
            p = this.preNext;
            this.preNext = null;
        }
        return p;
    }

    @Override
    public void remove() {
    }

    @Override
    public void close() {
        this.iterator.close();
        try {
            this.reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

