/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.iterators.mnd;

import hic.tools.utils.iterators.mnd.AlignmentPair;
import hic.tools.utils.iterators.mnd.AsciiPairIterator;
import hic.tools.utils.iterators.mnd.BinPairIterator;
import hic.tools.utils.iterators.mnd.GenericPairIterator;
import hic.tools.utils.iterators.mnd.ShortBinPairIterator;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;

public class AsciiToBinConverter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(String inputPath, String outputFile, ChromosomeHandler chromosomeHandler) throws IOException {
        HashMap<String, Integer> chromosomeOrdinals = new HashMap<String, Integer>();
        for (Chromosome c : chromosomeHandler.getChromosomeArray()) {
            chromosomeOrdinals.put(c.getName(), c.getIndex());
        }
        try (GenericPairIterator iter = null;
             BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outputFile));){
            LittleEndianOutputStream les = new LittleEndianOutputStream(bos);
            iter = new AsciiPairIterator(inputPath, chromosomeOrdinals, chromosomeHandler, true);
            if (outputFile.endsWith(".bn")) {
                AsciiToBinConverter.writeOutShortBinaryFormat((AsciiPairIterator)iter, les);
            } else {
                AsciiToBinConverter.writeOutStandardBinaryFormat((AsciiPairIterator)iter, les);
            }
            les.flush();
            bos.flush();
        }
    }

    private static void writeOutShortBinaryFormat(AsciiPairIterator iter, LittleEndianOutputStream les) throws IOException {
        while (iter.hasNext()) {
            AlignmentPair pair = iter.next();
            les.writeInt(pair.getChr1());
            les.writeInt(pair.getPos1());
            les.writeInt(pair.getChr2());
            les.writeInt(pair.getPos2());
            les.writeFloat(pair.getScore());
        }
    }

    private static void writeOutStandardBinaryFormat(AsciiPairIterator iter, LittleEndianOutputStream les) throws IOException {
        while (iter.hasNext()) {
            AlignmentPair pair = iter.next();
            les.writeBoolean(pair.getStrand1());
            les.writeInt(pair.getChr1());
            les.writeInt(pair.getPos1());
            les.writeInt(pair.getFrag1());
            les.writeBoolean(pair.getStrand2());
            les.writeInt(pair.getChr2());
            les.writeInt(pair.getPos2());
            les.writeInt(pair.getFrag2());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertBack(String inputPath, String outputFile) throws IOException {
        try (PrintWriter pw = null;){
            File f = new File(outputFile);
            FileWriter fw = new FileWriter(f);
            pw = new PrintWriter(fw);
            BinPairIterator iter = inputPath.endsWith(".bn") ? new ShortBinPairIterator(inputPath) : new BinPairIterator(inputPath);
            while (iter.hasNext()) {
                AlignmentPair pair = iter.next();
                pw.println(pair);
            }
        }
    }
}

