/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.iterators.mnd;

import hic.tools.utils.iterators.mnd.ComplexLineParser;
import hic.tools.utils.iterators.mnd.GenericPairIterator;
import hic.tools.utils.iterators.mnd.MNDFileParser;
import hic.tools.utils.iterators.mnd.PairIterator;
import hic.tools.utils.original.Chunk;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javastraw.reader.basics.ChromosomeHandler;
import org.broad.igv.util.ParsingUtils;

public class AsciiPairIterator
extends GenericPairIterator
implements PairIterator {
    private int mndChunkSize = 0;
    private int mndChunkCounter = 0;
    private boolean stopAfterChunk = false;

    public AsciiPairIterator(String path, Map<String, Integer> chromosomeOrdinals, ChromosomeHandler handler, boolean allowNewChroms) throws IOException {
        super(new MNDFileParser(new ComplexLineParser(chromosomeOrdinals, handler, allowNewChroms, true)));
        if (path.endsWith(".gz")) {
            GZIPInputStream gzipStream = new GZIPInputStream(new FileInputStream(path));
            InputStreamReader decoder = new InputStreamReader((InputStream)gzipStream, StandardCharsets.UTF_8);
            this.reader = new BufferedReader(decoder, 0x400000);
        } else {
            this.reader = new BufferedReader(new InputStreamReader(ParsingUtils.openInputStream(path)), 0x200000);
        }
        this.advance();
    }

    public AsciiPairIterator(String path, Map<String, Integer> chromosomeOrdinals, Chunk chunk, ChromosomeHandler handler) throws IOException {
        super(new MNDFileParser(new ComplexLineParser(chromosomeOrdinals, handler, false, false)));
        if (path.endsWith(".gz")) {
            System.err.println("Multithreading with indexed mnd currently only works with unzipped mnd");
            System.exit(70);
        } else {
            FileInputStream fis = new FileInputStream(path);
            fis.getChannel().position(chunk.mndIndex);
            this.reader = new BufferedReader(new InputStreamReader(fis), 0x200000);
            this.mndChunkSize = chunk.mndChunk;
            this.stopAfterChunk = true;
        }
        this.advance();
    }

    @Override
    protected String validateLine(String nextLine) {
        if (nextLine != null) {
            this.mndChunkCounter += nextLine.length() + 1;
            if (this.stopAfterChunk && this.mndChunkCounter > this.mndChunkSize) {
                return null;
            }
        }
        return nextLine;
    }
}

