/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.iterators.mnd;

public class AlignmentPair {
    private boolean strand1 = true;
    private boolean strand2 = false;
    private int frag1 = 0;
    private int frag2 = 1;
    private final int chr1;
    private final int pos1;
    private final int chr2;
    private final int pos2;
    private int mapq1 = 1000;
    private int mapq2 = 1000;
    private float score = 1.0f;
    private boolean isNotContigPair;
    private boolean isValidForStats = true;

    public AlignmentPair(boolean strand1, int chr1, int pos1, int frag1, int mapq1, boolean strand2, int chr2, int pos2, int frag2, int mapq2) {
        this.strand1 = strand1;
        this.chr1 = chr1;
        this.pos1 = pos1;
        this.frag1 = frag1;
        this.mapq1 = mapq1;
        this.strand2 = strand2;
        this.chr2 = chr2;
        this.pos2 = pos2;
        this.frag2 = frag2;
        this.mapq2 = mapq2;
        this.isNotContigPair = true;
    }

    public AlignmentPair() {
        this(false, -1, -1, -1, -1, false, -1, -1, -1, -1);
        this.isNotContigPair = false;
        this.isValidForStats = false;
    }

    public AlignmentPair(boolean ignore) {
        this();
        this.isNotContigPair = true;
        this.isValidForStats = false;
    }

    public AlignmentPair(int chr1, int pos1, int chr2, int pos2) {
        this.chr1 = chr1;
        this.pos1 = pos1;
        this.chr2 = chr2;
        this.pos2 = pos2;
        this.isNotContigPair = true;
    }

    public AlignmentPair(boolean strand1, int chr1, int pos1, int frag1, boolean strand2, int chr2, int pos2, int frag2) {
        this.strand1 = strand1;
        this.chr1 = chr1;
        this.pos1 = pos1;
        this.frag1 = frag1;
        this.strand2 = strand2;
        this.chr2 = chr2;
        this.pos2 = pos2;
        this.frag2 = frag2;
        this.isNotContigPair = true;
    }

    public int getChr1() {
        return this.chr1;
    }

    public int getPos1() {
        return this.pos1;
    }

    public int getChr2() {
        return this.chr2;
    }

    public int getPos2() {
        return this.pos2;
    }

    public int getMapq1() {
        return this.mapq1;
    }

    public int getMapq2() {
        return this.mapq2;
    }

    public boolean getStrand1() {
        return this.strand1;
    }

    private int getStrand1AsInt() {
        return this.strand1 ? 0 : 16;
    }

    private int getStrand2AsInt() {
        return this.strand2 ? 0 : 16;
    }

    public boolean getStrand2() {
        return this.strand2;
    }

    public int getFrag1() {
        return this.frag1;
    }

    public int getFrag2() {
        return this.frag2;
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score1) {
        this.score = score1;
    }

    public String toString() {
        int str1 = this.getStrand1AsInt();
        int str2 = this.getStrand2AsInt();
        return str1 + "\t" + this.chr1 + "\t" + this.pos1 + "\t" + this.frag1 + "\t" + this.mapq1 + "\t" + str2 + "\t" + this.chr2 + "\t" + this.pos2 + "\t" + this.frag2 + "\t" + this.mapq2 + "\t" + this.score;
    }

    public boolean isNotContigPair() {
        return this.isNotContigPair;
    }

    public boolean isValid() {
        return this.isValidForStats;
    }

    public boolean isShort() {
        return this.mapq1 == 1000 && this.mapq2 == 1000;
    }

    public void updateFragments(int frag1, int frag2) {
        this.frag1 = frag1;
        this.frag2 = frag2;
    }

    public void updateStrands(boolean strand1, boolean strand2) {
        this.strand1 = strand1;
        this.strand2 = strand2;
    }

    public void updateMAPQs(int mapq1, int mapq2) {
        this.mapq1 = mapq1;
        this.mapq2 = mapq2;
    }
}

