/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.iterators.contacts;

import hic.tools.utils.iterators.contacts.Contact;
import hic.tools.utils.iterators.contacts.ContactIterator;
import java.util.Iterator;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.mzd.MatrixZoomData;

public class ChromosomeContactsIterator
implements ContactIterator {
    private final int chr1;
    private final int chr2;
    private final Iterator<ContactRecord> iterator;
    private final int resolution;

    public ChromosomeContactsIterator(MatrixZoomData zd, Chromosome chromosome1, Chromosome chromosome2, int resolution) {
        this.chr1 = chromosome1.getIndex();
        this.chr2 = chromosome2.getIndex();
        this.resolution = resolution;
        this.iterator = zd.getDirectIterator();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            return false;
        }
        return this.iterator.hasNext();
    }

    @Override
    public Contact next() {
        return new Contact(this.chr1, this.chr2, this.iterator.next(), this.resolution);
    }
}

