/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.iterators.contacts;

import hic.tools.utils.iterators.contacts.Contact;
import hic.tools.utils.iterators.contacts.ContactIterator;
import java.io.IOException;
import java.util.Iterator;
import javastraw.reader.Dataset;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.mzd.Matrix;
import javastraw.reader.mzd.MatrixZoomData;

public class AllByAllContactsIterator
implements ContactIterator {
    private final Dataset[] datasets;
    private int currentIndex = -1;
    private MatrixZoomData zd = null;
    private Matrix matrix = null;
    private Iterator<ContactRecord> iterator = null;
    private int resolution;

    public AllByAllContactsIterator(Dataset[] datasets) throws IOException {
        this.datasets = datasets;
        this.advanceIterator();
    }

    private static Contact makeAlignmentPairFromRecord(ContactRecord record, int resolution) {
        return new Contact(0, 0, record, resolution);
    }

    private void advanceIterator() {
        if (this.currentIndex > -1 && this.zd != null && this.matrix != null && this.iterator != null) {
            this.iterator = null;
        }
        ++this.currentIndex;
        if (this.currentIndex < this.datasets.length) {
            Chromosome all = this.datasets[this.currentIndex].getChromosomeHandler().getChromosomeFromIndex(0);
            this.matrix = this.datasets[this.currentIndex].getMatrix(all, all);
            this.zd = this.matrix.getFirstZoomData();
            this.iterator = this.zd.getDirectIterator();
            this.resolution = this.zd.getBinSize();
        } else {
            this.iterator = null;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.iterator.hasNext()) {
            return true;
        }
        do {
            this.advanceIterator();
            if (this.iterator == null || !this.iterator.hasNext()) continue;
            return true;
        } while (this.currentIndex < this.datasets.length);
        return false;
    }

    @Override
    public Contact next() {
        ContactRecord record = this.iterator.next();
        return AllByAllContactsIterator.makeAlignmentPairFromRecord(record, this.resolution);
    }
}

