/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.cleaner;

import hic.tools.utils.iterators.mnd.AlignmentPair;
import hic.tools.utils.original.ExpectedValueCalculation;
import hic.tools.utils.original.MatrixPP;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javastraw.reader.basics.ChromosomeHandler;

public class ContactCleaner {
    protected final ChromosomeHandler handler;
    protected int chr1;
    protected int chr2;
    protected int bp1;
    protected int bp2;
    protected int frag1;
    protected int frag2;
    private float score;

    public ContactCleaner(ChromosomeHandler chromosomeHandler) {
        this.handler = chromosomeHandler;
    }

    public static int getWholeGenomePosition(int chr, int pos, ChromosomeHandler handler) {
        long len = 0L;
        for (int i = 1; i < chr; ++i) {
            len += handler.getChromosomeFromIndex(i).getLength();
        }
        return (int)((len += (long)pos) / 1000L);
    }

    public void updateLatestContact(AlignmentPair pair) {
        if (this.isUpperTriangular(pair)) {
            this.bp1 = pair.getPos1();
            this.bp2 = pair.getPos2();
            this.frag1 = pair.getFrag1();
            this.frag2 = pair.getFrag2();
            this.chr1 = pair.getChr1();
            this.chr2 = pair.getChr2();
        } else {
            this.bp1 = pair.getPos2();
            this.bp2 = pair.getPos1();
            this.frag1 = pair.getFrag2();
            this.frag2 = pair.getFrag1();
            this.chr1 = pair.getChr2();
            this.chr2 = pair.getChr1();
        }
        this.score = pair.getScore();
        this.bp1 = this.ensureFitInChromosomeBounds(this.bp1, this.chr1);
        this.bp2 = this.ensureFitInChromosomeBounds(this.bp2, this.chr2);
    }

    private boolean isUpperTriangular(AlignmentPair pair) {
        boolean isIntra = pair.getChr1() == pair.getChr2();
        boolean isUpperTriangular = pair.getPos1() <= pair.getPos2();
        boolean isInterUpperTriangular = pair.getChr1() < pair.getChr2();
        return isIntra && isUpperTriangular || isInterUpperTriangular;
    }

    protected int ensureFitInChromosomeBounds(int bp, int chrom) {
        if (bp < 0) {
            return 0;
        }
        long maxLength = this.handler.getChromosomeFromIndex(chrom).getLength();
        if ((long)bp > maxLength) {
            return (int)maxLength;
        }
        return bp;
    }

    public void incrementCount(MatrixPP currentMatrix, Map<String, ExpectedValueCalculation> expectedValueCalculations, File tmpDir) throws IOException {
        if (currentMatrix != null) {
            currentMatrix.incrementCount(this.bp1, this.bp2, this.score, expectedValueCalculations, tmpDir);
        }
    }

    public boolean doesntMatchCurrentBlock(int currentChr1, int currentChr2) {
        return currentChr1 != this.chr1 || currentChr2 != this.chr2;
    }

    public int getChr1() {
        return this.chr1;
    }

    public int getChr2() {
        return this.chr2;
    }

    public void incrementGWCount(MatrixPP wholeGenomeMatrix, Map<String, ExpectedValueCalculation> localExpectedValueCalculations, File tmpDir) throws IOException {
        int pos1 = ContactCleaner.getWholeGenomePosition(this.chr1, this.bp1, this.handler);
        int pos2 = ContactCleaner.getWholeGenomePosition(this.chr2, this.bp2, this.handler);
        wholeGenomeMatrix.incrementCount(pos1, pos2, this.score, localExpectedValueCalculations, tmpDir);
    }

    public String getCurrentMatrixName() {
        return this.handler.getChromosomeFromIndex(this.chr1).getName() + "-" + this.handler.getChromosomeFromIndex(this.chr2).getName();
    }
}

